/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal.grpc;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.okhttp.OkHttpChannelBuilder;
import io.opentelemetry.exporter.otlp.internal.TlsUtil;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class ManagedChannelUtil {
    private static final Logger logger = Logger.getLogger(ManagedChannelUtil.class.getName());

    public static void setTrustedCertificatesPem(ManagedChannelBuilder<?> managedChannelBuilder, byte[] trustedCertificatesPem) throws SSLException {
        Objects.requireNonNull(managedChannelBuilder, "managedChannelBuilder");
        Objects.requireNonNull(trustedCertificatesPem, "trustedCertificatesPem");
        X509TrustManager tmf = TlsUtil.trustManager(trustedCertificatesPem);
        if (managedChannelBuilder.getClass().getName().equals("io.grpc.netty.NettyChannelBuilder")) {
            NettyChannelBuilder nettyBuilder = (NettyChannelBuilder)managedChannelBuilder;
            nettyBuilder.sslContext(io.grpc.netty.GrpcSslContexts.forClient().trustManager((TrustManager)tmf).build());
        } else if (managedChannelBuilder.getClass().getName().equals("io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder")) {
            io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder nettyBuilder = (io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder)managedChannelBuilder;
            nettyBuilder.sslContext(GrpcSslContexts.forClient().trustManager(tmf).build());
        } else if (managedChannelBuilder.getClass().getName().equals("io.grpc.okhttp.OkHttpChannelBuilder")) {
            OkHttpChannelBuilder okHttpBuilder = (OkHttpChannelBuilder)managedChannelBuilder;
            okHttpBuilder.sslSocketFactory(TlsUtil.sslSocketFactory(tmf));
        } else {
            throw new SSLException("TLS certificate configuration not supported for unrecognized ManagedChannelBuilder " + managedChannelBuilder.getClass().getName());
        }
    }

    public static CompletableResultCode shutdownChannel(ManagedChannel managedChannel) {
        CompletableResultCode result = new CompletableResultCode();
        managedChannel.shutdown();
        Thread thread = new Thread(() -> {
            try {
                managedChannel.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.log(Level.WARNING, "Failed to shutdown the gRPC channel", e);
                result.fail();
            }
            result.succeed();
        });
        thread.setDaemon(true);
        thread.setName("grpc-cleanup");
        thread.start();
        return result;
    }

    private ManagedChannelUtil() {
    }
}

