/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.trace;

import io.opentelemetry.exporter.otlp.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.otlp.internal.traces.TraceRequestMarshaler;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcSpanExporter
implements SpanExporter {
    private final GrpcExporter<TraceRequestMarshaler> delegate;

    public static OtlpGrpcSpanExporter getDefault() {
        return OtlpGrpcSpanExporter.builder().build();
    }

    public static OtlpGrpcSpanExporterBuilder builder() {
        return new OtlpGrpcSpanExporterBuilder();
    }

    OtlpGrpcSpanExporter(GrpcExporter<TraceRequestMarshaler> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spans) {
        TraceRequestMarshaler request = TraceRequestMarshaler.create(spans);
        return this.delegate.export(request, spans.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }
}

