/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ChainedExecutionListener
implements ExecutionListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<ExecutionListener> listeners;

    ChainedExecutionListener(ExecutionListener ... listeners) {
        this.listeners = Arrays.stream(listeners).filter(e -> e != null).collect(Collectors.toList());
    }

    public void projectDiscoveryStarted(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.projectDiscoveryStarted(event);
        }
    }

    public void sessionStarted(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.sessionStarted(event);
        }
    }

    public void sessionEnded(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.sessionEnded(event);
        }
    }

    public void projectSkipped(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.projectSkipped(event);
        }
    }

    public void projectStarted(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.projectStarted(event);
        }
    }

    public void projectSucceeded(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.projectSucceeded(event);
        }
    }

    public void projectFailed(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.projectFailed(event);
        }
    }

    public void mojoSkipped(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.mojoSkipped(event);
        }
    }

    public void mojoStarted(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.mojoStarted(event);
        }
    }

    public void mojoSucceeded(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.mojoSucceeded(event);
        }
    }

    public void mojoFailed(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.mojoFailed(event);
        }
    }

    public void forkStarted(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.forkStarted(event);
        }
    }

    public void forkSucceeded(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.forkSucceeded(event);
        }
    }

    public void forkFailed(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.forkFailed(event);
        }
    }

    public void forkedProjectStarted(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.forkedProjectStarted(event);
        }
    }

    public void forkedProjectSucceeded(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.forkedProjectSucceeded(event);
        }
    }

    public void forkedProjectFailed(ExecutionEvent event) {
        for (ExecutionListener listener : this.listeners) {
            listener.forkedProjectFailed(event);
        }
    }
}

