/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.maven.OtelUtils;
import io.opentelemetry.maven.StringUtils;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.OpenTelemetrySdkAutoConfiguration;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=OpenTelemetrySdkService.class, hint="opentelemetry-service")
public final class OpenTelemetrySdkService
implements Initializable,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(OpenTelemetrySdkService.class);
    @Requirement
    private RuntimeInformation runtimeInformation;
    private OpenTelemetry openTelemetry = OpenTelemetry.noop();
    private OpenTelemetrySdk openTelemetrySdk;
    private Tracer tracer;
    private SpanExporter spanExporter;
    private boolean mojosInstrumentationEnabled;

    public synchronized void dispose() {
        logger.debug("OpenTelemetry: dispose OpenTelemetrySdkService...");
        if (this.openTelemetrySdk != null) {
            logger.debug("OpenTelemetry: Shutdown SDK Trace Provider...");
            CompletableResultCode sdkProviderShutdown = this.openTelemetrySdk.getSdkTracerProvider().shutdown();
            sdkProviderShutdown.join(10L, TimeUnit.SECONDS);
            if (sdkProviderShutdown.isSuccess()) {
                logger.debug("OpenTelemetry: SDK Trace Provider shut down");
            } else {
                logger.warn("OpenTelemetry: Failure to shutdown SDK Trace Provider (done: " + sdkProviderShutdown.isDone() + ")");
            }
            this.openTelemetrySdk = null;
        }
        this.openTelemetry = null;
        logger.debug("OpenTelemetry: OpenTelemetrySdkService disposed");
    }

    public void initialize() throws InitializationException {
        logger.debug("OpenTelemetry: initialize OpenTelemetrySdkService...");
        if (StringUtils.isBlank(OtelUtils.getSystemPropertyOrEnvironmentVariable("otel.exporter.otlp.endpoint", "OTEL_EXPORTER_OTLP_ENDPOINT", null))) {
            logger.debug("OpenTelemetry: No -Dotel.exporter.otlp.endpoint property or OTEL_EXPORTER_OTLP_ENDPOINT environment variable found, use a NOOP OpenTelemetry SDK");
        } else {
            String initialCommaSeparatedAttributes = OtelUtils.getSystemPropertyOrEnvironmentVariable("otel.resource.attributes", "OTEL_RESOURCE_ATTRIBUTES", "");
            Map<String, String> attributes = OtelUtils.getCommaSeparatedMap(initialCommaSeparatedAttributes);
            String serviceName = OtelUtils.getSystemPropertyOrEnvironmentVariable("otel.service.name", "OTEL_SERVICE_NAME", null);
            if (!attributes.containsKey(ResourceAttributes.SERVICE_NAME.getKey()) && StringUtils.isBlank(serviceName)) {
                attributes.put(ResourceAttributes.SERVICE_NAME.getKey(), "maven");
            }
            String mavenVersion = this.runtimeInformation.getMavenVersion();
            if (!attributes.containsKey(ResourceAttributes.SERVICE_VERSION.getKey())) {
                attributes.put(ResourceAttributes.SERVICE_VERSION.getKey(), mavenVersion);
            }
            String newCommaSeparatedAttributes = OtelUtils.getCommaSeparatedString(attributes);
            logger.debug("OpenTelemetry: Initial resource attributes: {}", (Object)initialCommaSeparatedAttributes);
            logger.debug("OpenTelemetry: Use resource attributes: {}", (Object)newCommaSeparatedAttributes);
            System.setProperty("otel.resource.attributes", newCommaSeparatedAttributes);
            this.openTelemetrySdk = OpenTelemetrySdkAutoConfiguration.initialize(false);
            this.openTelemetry = this.openTelemetrySdk;
        }
        String mojosInstrumentationEnabledAsString = System.getProperty("otel.instrumentation.maven.mojo.enabled", System.getenv("OTEL_INSTRUMENTATION_MAVEN_MOJO_ENABLED"));
        this.mojosInstrumentationEnabled = Boolean.parseBoolean(StringUtils.defaultIfBlank(mojosInstrumentationEnabledAsString, "true"));
        this.tracer = this.openTelemetry.getTracer("io.opentelemetry.contrib.maven");
    }

    public Tracer getTracer() {
        if (this.tracer == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.tracer;
    }

    public ContextPropagators getPropagators() {
        return this.openTelemetry.getPropagators();
    }

    public boolean isMojosInstrumentationEnabled() {
        return this.mojosInstrumentationEnabled;
    }
}

