/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import io.opentelemetry.maven.StringUtils;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

final class OtelUtils {
    OtelUtils() {
    }

    public static String getCommaSeparatedString(Map<String, String> keyValuePairs) {
        return keyValuePairs.entrySet().stream().map(keyValuePair -> (String)keyValuePair.getKey() + "=" + (String)keyValuePair.getValue()).collect(Collectors.joining(","));
    }

    public static Map<String, String> getCommaSeparatedMap(String commaSeparatedKeyValuePairs) {
        if (StringUtils.isBlank(commaSeparatedKeyValuePairs)) {
            return new HashMap<String, String>();
        }
        return OtelUtils.filterBlanksAndNulls(commaSeparatedKeyValuePairs.split(",")).stream().map(keyValuePair -> OtelUtils.filterBlanksAndNulls(keyValuePair.split("=", 2))).map(splitKeyValuePairs -> {
            if (splitKeyValuePairs.size() != 2) {
                throw new RuntimeException("Invalid key-value pair: " + commaSeparatedKeyValuePairs);
            }
            return new AbstractMap.SimpleImmutableEntry<String, String>((String)splitKeyValuePairs.get(0), (String)splitKeyValuePairs.get(1));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (first, next) -> next, LinkedHashMap::new));
    }

    private static List<String> filterBlanksAndNulls(String[] values) {
        return Arrays.stream(values).map(String::trim).filter(s2 -> !s2.isEmpty()).collect(Collectors.toList());
    }

    @CheckForNull
    public static String getSystemPropertyOrEnvironmentVariable(String systemPropertyName, String environmentVariableName, @Nullable String defaultValue) {
        String systemProperty = System.getProperty(systemPropertyName);
        if (StringUtils.isNotBlank(systemProperty)) {
            return systemProperty;
        }
        String environmentVariable = System.getenv(environmentVariableName);
        if (StringUtils.isNotBlank(environmentVariable)) {
            return environmentVariable;
        }
        return defaultValue;
    }
}

