/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.maven.AutoValue_SpanRegistry_MavenProjectKey;
import io.opentelemetry.maven.AutoValue_SpanRegistry_MojoExecutionKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=SpanRegistry.class)
public final class SpanRegistry {
    private final Map<MojoExecutionKey, Span> mojoExecutionKeySpanMap = new ConcurrentHashMap<MojoExecutionKey, Span>();
    private final Map<MavenProjectKey, Span> mavenProjectKeySpanMap = new ConcurrentHashMap<MavenProjectKey, Span>();
    private Span rootSpan;

    public void setRootSpan(@Nonnull Span rootSpan) throws IllegalStateException {
        if (this.rootSpan != null) {
            throw new IllegalStateException("Root span already defined " + this.rootSpan);
        }
        this.rootSpan = rootSpan;
    }

    public Span getSpan(@Nonnull MavenProject mavenProject) {
        MavenProjectKey key = MavenProjectKey.fromMavenProject(mavenProject);
        Span span = this.mavenProjectKeySpanMap.get(key);
        if (span == null) {
            throw new IllegalStateException("Span not started for project " + mavenProject.getGroupId() + ":" + mavenProject.getArtifactId());
        }
        return span;
    }

    public Span getRootSpanNotNull() {
        if (this.rootSpan == null) {
            throw new IllegalStateException("Root span not defined");
        }
        return this.rootSpan;
    }

    public Span removeRootSpan() {
        if (this.rootSpan == null) {
            throw new IllegalStateException("Root span not defined");
        }
        if (!this.mojoExecutionKeySpanMap.isEmpty()) {
            throw new IllegalStateException("Remaining children spans: " + this.mojoExecutionKeySpanMap.keySet().stream().map(Object::toString).collect(Collectors.joining(", ")));
        }
        return this.rootSpan;
    }

    public void putSpan(Span span, MavenProject mavenProject) {
        MavenProjectKey key = MavenProjectKey.fromMavenProject(mavenProject);
        Span previousSpanForKey = this.mavenProjectKeySpanMap.put(key, span);
        if (previousSpanForKey != null) {
            throw new IllegalStateException("A span has already been started for " + mavenProject);
        }
    }

    public Span removeSpan(MavenProject mavenProject) throws IllegalStateException {
        MavenProjectKey key = MavenProjectKey.fromMavenProject(mavenProject);
        Span span = this.mavenProjectKeySpanMap.remove(key);
        if (span == null) {
            throw new IllegalStateException("No span found for " + mavenProject);
        }
        return span;
    }

    public void putSpan(Span span, MojoExecution mojoExecution) {
        MojoExecutionKey key = MojoExecutionKey.fromMojoExecution(mojoExecution);
        Span previousSpanForKey = this.mojoExecutionKeySpanMap.put(key, span);
        if (previousSpanForKey != null) {
            throw new IllegalStateException("A span has already been started for " + mojoExecution);
        }
    }

    @Nonnull
    public Span removeSpan(MojoExecution mojoExecution) throws IllegalStateException {
        MojoExecutionKey key = MojoExecutionKey.fromMojoExecution(mojoExecution);
        Span span = this.mojoExecutionKeySpanMap.remove(key);
        if (span == null) {
            throw new IllegalStateException("No span found for " + mojoExecution);
        }
        return span;
    }

    @AutoValue
    static abstract class MavenProjectKey {
        MavenProjectKey() {
        }

        abstract String groupId();

        abstract String artifactId();

        public static MavenProjectKey fromMavenProject(@Nonnull MavenProject mavenProject) {
            return new AutoValue_SpanRegistry_MavenProjectKey(mavenProject.getGroupId(), mavenProject.getArtifactId());
        }
    }

    @AutoValue
    static abstract class MojoExecutionKey {
        MojoExecutionKey() {
        }

        abstract String executionId();

        abstract String goal();

        abstract String groupId();

        abstract String artifactId();

        abstract String pluginGroupId();

        abstract String pluginArtifactId();

        static MojoExecutionKey fromMojoExecution(MojoExecution mojoExecution) {
            if (mojoExecution == null) {
                throw new NullPointerException("Given MojoExecution is null");
            }
            Plugin plugin = mojoExecution.getPlugin();
            if (plugin == null) {
                throw new NullPointerException("Plugin is null for MojoExecution " + mojoExecution.identify());
            }
            return new AutoValue_SpanRegistry_MojoExecutionKey(mojoExecution.getExecutionId(), mojoExecution.getGoal(), mojoExecution.getGroupId(), mojoExecution.getArtifactId(), plugin.getGroupId(), plugin.getArtifactId());
        }
    }
}

