/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.metrics.SdkMeter;
import io.opentelemetry.sdk.metrics.SdkMeterBuilder;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.MetricReaderFactory;
import io.opentelemetry.sdk.metrics.internal.export.CollectionHandle;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.view.ViewRegistry;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class DefaultSdkMeterProvider
implements SdkMeterProvider {
    private static final Logger LOGGER = Logger.getLogger(DefaultSdkMeterProvider.class.getName());
    static final String DEFAULT_METER_NAME = "unknown";
    private final ComponentRegistry<SdkMeter> registry;
    private final MeterProviderSharedState sharedState;
    private final Set<CollectionHandle> collectors;
    private final List<MetricReader> readers;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicLong lastCollectionTimestamp;
    private static final long MINIMUM_COLLECTION_INTERVAL_NANOS = TimeUnit.MILLISECONDS.toNanos(100L);

    DefaultSdkMeterProvider(List<MetricReaderFactory> readerFactories, Clock clock, Resource resource, ViewRegistry viewRegistry, ExemplarFilter exemplarSampler) {
        this.sharedState = MeterProviderSharedState.create(clock, resource, viewRegistry, exemplarSampler);
        this.registry = new ComponentRegistry<SdkMeter>(instrumentationLibraryInfo -> new SdkMeter(this.sharedState, (InstrumentationLibraryInfo)instrumentationLibraryInfo));
        this.lastCollectionTimestamp = new AtomicLong(clock.nanoTime() - MINIMUM_COLLECTION_INTERVAL_NANOS);
        this.collectors = CollectionHandle.mutableSet();
        this.readers = new ArrayList<MetricReader>();
        Supplier<CollectionHandle> handleSupplier = CollectionHandle.createSupplier();
        for (MetricReaderFactory readerFactory : readerFactories) {
            CollectionHandle handle = handleSupplier.get();
            MetricReader reader = readerFactory.apply(new LeasedMetricProducer(handle));
            this.collectors.add(handle);
            this.readers.add(reader);
        }
    }

    @Override
    public MeterBuilder meterBuilder(@Nullable String instrumentationName) {
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            LOGGER.fine("Meter requested without instrumentation name.");
            instrumentationName = DEFAULT_METER_NAME;
        }
        return new SdkMeterBuilder(this.registry, instrumentationName);
    }

    @Override
    public CompletableResultCode forceFlush() {
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>();
        for (MetricReader reader : this.readers) {
            results.add(reader.flush());
        }
        return CompletableResultCode.ofAll(results);
    }

    @Override
    public CompletableResultCode close() {
        if (!this.isClosed.compareAndSet(false, true)) {
            LOGGER.info("Multiple close calls");
            return CompletableResultCode.ofSuccess();
        }
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>();
        for (MetricReader reader : this.readers) {
            results.add(reader.shutdown());
        }
        return CompletableResultCode.ofAll(results);
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.close();
    }

    private class LeasedMetricProducer
    implements MetricProducer {
        private final CollectionHandle handle;

        LeasedMetricProducer(CollectionHandle handle) {
            this.handle = handle;
        }

        @Override
        public Collection<MetricData> collectAllMetrics() {
            long pastNanoTime;
            boolean disableSynchronousCollection;
            Collection meters = DefaultSdkMeterProvider.this.registry.getComponents();
            long currentNanoTime = DefaultSdkMeterProvider.this.sharedState.getClock().nanoTime();
            boolean bl = disableSynchronousCollection = currentNanoTime - (pastNanoTime = DefaultSdkMeterProvider.this.lastCollectionTimestamp.get()) < MINIMUM_COLLECTION_INTERVAL_NANOS;
            if (!disableSynchronousCollection) {
                DefaultSdkMeterProvider.this.lastCollectionTimestamp.lazySet(currentNanoTime);
            }
            ArrayList<MetricData> result = new ArrayList<MetricData>(meters.size());
            for (SdkMeter meter : meters) {
                result.addAll(meter.collectAll(this.handle, DefaultSdkMeterProvider.this.collectors, DefaultSdkMeterProvider.this.sharedState.getClock().now(), disableSynchronousCollection));
            }
            return Collections.unmodifiableCollection(result);
        }
    }
}

