/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleHistogramAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;
import java.util.function.Supplier;

final class HistogramAggregatorFactory
implements AggregatorFactory {
    private final double[] boundaries;
    private final AggregationTemporality temporality;

    HistogramAggregatorFactory(List<Double> boundaries, AggregationTemporality temporality) {
        this.boundaries = ExplicitBucketHistogramUtils.createBoundaryArray(boundaries);
        this.temporality = temporality;
        for (double v : this.boundaries) {
            if (!Double.isNaN(v)) continue;
            throw new IllegalArgumentException("invalid bucket boundary: NaN");
        }
        for (int i = 1; i < this.boundaries.length; ++i) {
            if (!(this.boundaries[i - 1] >= this.boundaries[i])) continue;
            throw new IllegalArgumentException("invalid bucket boundary: " + this.boundaries[i - 1] + " >= " + this.boundaries[i]);
        }
        if (this.boundaries.length > 0) {
            if (this.boundaries[0] == Double.NEGATIVE_INFINITY) {
                throw new IllegalArgumentException("invalid bucket boundary: -Inf");
            }
            if (this.boundaries[this.boundaries.length - 1] == Double.POSITIVE_INFINITY) {
                throw new IllegalArgumentException("invalid bucket boundary: +Inf");
            }
        }
    }

    @Override
    public <T> Aggregator<T> create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor instrumentDescriptor, MetricDescriptor metricDescriptor, Supplier<ExemplarReservoir> reservoirSupplier) {
        boolean stateful = this.temporality == AggregationTemporality.CUMULATIVE;
        switch (instrumentDescriptor.getValueType()) {
            case LONG: 
            case DOUBLE: {
                return new DoubleHistogramAggregator(resource, instrumentationLibraryInfo, metricDescriptor, this.boundaries, stateful, reservoirSupplier);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }
}

