/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.export.CollectionHandle;
import io.opentelemetry.sdk.metrics.internal.state.DeltaMetricStorage;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class TemporalMetricStorage<T> {
    private final Aggregator<T> aggregator;
    private final boolean isSynchronous;
    private final Map<CollectionHandle, LastReportedAccumulation<T>> reportHistory = new HashMap<CollectionHandle, LastReportedAccumulation<T>>();

    TemporalMetricStorage(Aggregator<T> aggregator, boolean isSynchronous) {
        this.aggregator = aggregator;
        this.isSynchronous = isSynchronous;
    }

    @Nullable
    synchronized MetricData buildMetricFor(CollectionHandle collector, Map<Attributes, T> currentAccumulation, long startEpochNanos, long epochNanos) {
        long lastCollectionEpoch = startEpochNanos;
        Map<Attributes, T> result = currentAccumulation;
        if (this.reportHistory.containsKey(collector)) {
            LastReportedAccumulation<T> last = this.reportHistory.get(collector);
            lastCollectionEpoch = last.getEpochNanos();
            if (this.aggregator.isStateful()) {
                DeltaMetricStorage.mergeInPlace(last.getAccumlation(), currentAccumulation, this.aggregator);
                result = last.getAccumlation();
            }
        }
        if (this.isSynchronous) {
            this.reportHistory.put(collector, new LastReportedAccumulation<T>(result, epochNanos));
        } else {
            this.reportHistory.put(collector, new LastReportedAccumulation<T>(currentAccumulation, epochNanos));
        }
        if (result.isEmpty()) {
            return null;
        }
        return this.aggregator.toMetricData(result, startEpochNanos, lastCollectionEpoch, epochNanos);
    }

    private static class LastReportedAccumulation<T> {
        @Nullable
        private final Map<Attributes, T> accumulation;
        private final long epochNanos;

        LastReportedAccumulation(@Nullable Map<Attributes, T> accumulation, long epochNanos) {
            this.accumulation = accumulation;
            this.epochNanos = epochNanos;
        }

        long getEpochNanos() {
            return this.epochNanos;
        }

        @Nullable
        Map<Attributes, T> getAccumlation() {
            return this.accumulation;
        }
    }
}

