/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.testing;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.MetricReaderFactory;
import java.util.Collection;
import java.util.Collections;

public class InMemoryMetricReader
implements MetricReader,
MetricReaderFactory {
    private MetricProducer metricProducer;
    private volatile Collection<MetricData> latest = Collections.emptyList();

    public Collection<MetricData> collectAllMetrics() {
        this.flush();
        return this.latest;
    }

    @Override
    public CompletableResultCode flush() {
        if (this.metricProducer != null) {
            this.latest = this.metricProducer.collectAllMetrics();
        }
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public MetricReader apply(MetricProducer producer) {
        this.metricProducer = producer;
        return this;
    }
}

