/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer.internal;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.contrib.metrics.micrometer.CallbackRegistrar;
import io.opentelemetry.contrib.metrics.micrometer.CallbackRegistration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class PollingMeterCallbackRegistrar
implements CallbackRegistrar {
    static final String OTEL_POLLING_METER_NAME = "otel_polling_meter";
    private final Supplier<MeterRegistry> meterRegistrySupplier;
    private final List<Runnable> callbacks;
    @Nullable
    private volatile Meter pollingMeter;

    public PollingMeterCallbackRegistrar(Supplier<MeterRegistry> meterRegistrySupplier) {
        this.meterRegistrySupplier = meterRegistrySupplier;
        this.callbacks = new CopyOnWriteArrayList<Runnable>();
    }

    private void poll() {
        for (Runnable callback : this.callbacks) {
            callback.run();
        }
    }

    @Override
    public CallbackRegistration registerCallback(Runnable callback) {
        if (callback != null) {
            this.ensurePollingMeterCreated();
            this.callbacks.add(callback);
            return () -> this.callbacks.remove(callback);
        }
        return () -> {};
    }

    private synchronized void ensurePollingMeterCreated() {
        if (this.pollingMeter == null) {
            this.pollingMeter = this.createPollingMeter(this.meterRegistrySupplier.get());
        }
    }

    private Meter createPollingMeter(MeterRegistry meterRegistry) {
        return Meter.builder((String)OTEL_POLLING_METER_NAME, (Meter.Type)Meter.Type.OTHER, PollingIterable.of(this::poll)).register(meterRegistry);
    }

    @Override
    public synchronized void close() {
        if (this.pollingMeter != null) {
            this.meterRegistrySupplier.get().remove(this.pollingMeter);
            this.pollingMeter = null;
        }
    }

    private static class PollingIterable<T>
    implements Iterable<T>,
    Iterator<T> {
        private final Runnable callback;

        static <T> Iterable<T> of(Runnable callback) {
            return new PollingIterable<T>(callback);
        }

        public PollingIterable(Runnable callback) {
            this.callback = callback;
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            this.callback.run();
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }
    }
}

