/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.muzzle;

import io.opentelemetry.javaagent.muzzle.MuzzleDirective;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\b&\u0018\u0000 52\u00020\u0001:\u00015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0011\u001a\u00020*J\u0010\u0010+\u001a\u00020*2\b\u0010,\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010-\u001a\u00020*2\u0006\u0010,\u001a\u00020\u000fJ\u000e\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0001J#\u00100\u001a\u00020*2\u0016\u00101\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f02\"\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020\u000fH\u0016R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000bR\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000bR\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000bR\u0014\u0010\u001f\u001a\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0#8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0018R\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000b\u00a8\u00066"}, d2={"Lio/opentelemetry/javaagent/muzzle/MuzzleDirective;", "", "()V", "additionalDependencies", "Lorg/gradle/api/provider/ListProperty;", "getAdditionalDependencies", "()Lorg/gradle/api/provider/ListProperty;", "assertInverse", "Lorg/gradle/api/provider/Property;", "", "getAssertInverse", "()Lorg/gradle/api/provider/Property;", "assertPass", "getAssertPass", "classifier", "", "getClassifier", "coreJdk", "getCoreJdk$gradle_plugins", "excludedDependencies", "getExcludedDependencies", "excludedInstrumentationNames", "Lorg/gradle/api/provider/SetProperty;", "getExcludedInstrumentationNames", "()Lorg/gradle/api/provider/SetProperty;", "group", "getGroup", "module", "getModule", "name", "getName", "nameSlug", "getNameSlug$gradle_plugins", "()Ljava/lang/String;", "normalizedSkipVersions", "", "getNormalizedSkipVersions$gradle_plugins", "()Ljava/util/Set;", "skipVersions", "getSkipVersions", "versions", "getVersions", "", "excludeDependency", "excludeString", "excludeInstrumentationName", "extraDependency", "dependencyNotation", "skip", "version", "", "([Ljava/lang/String;)V", "toString", "Companion", "gradle-plugins"})
public abstract class MuzzleDirective {
    private static final Regex NORMALIZE_NAME_SLUG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public abstract Property<String> getName();

    @NotNull
    public abstract Property<String> getGroup();

    @NotNull
    public abstract Property<String> getModule();

    @NotNull
    public abstract Property<String> getClassifier();

    @NotNull
    public abstract Property<String> getVersions();

    @NotNull
    public abstract SetProperty<String> getSkipVersions();

    @NotNull
    public abstract ListProperty<Object> getAdditionalDependencies();

    @NotNull
    public abstract ListProperty<String> getExcludedDependencies();

    @NotNull
    public abstract SetProperty<String> getExcludedInstrumentationNames();

    @NotNull
    public abstract Property<Boolean> getAssertPass();

    @NotNull
    public abstract Property<Boolean> getAssertInverse();

    @NotNull
    public abstract Property<Boolean> getCoreJdk$gradle_plugins();

    public final void coreJdk() {
        this.getCoreJdk$gradle_plugins().set((Object)true);
    }

    public final void extraDependency(@NotNull Object dependencyNotation) {
        Intrinsics.checkNotNullParameter((Object)dependencyNotation, (String)"dependencyNotation");
        this.getAdditionalDependencies().add(dependencyNotation);
    }

    public final void excludeDependency(@Nullable String excludeString) {
        ListProperty<String> listProperty = this.getExcludedDependencies();
        String string = excludeString;
        Intrinsics.checkNotNull((Object)string);
        listProperty.add((Object)string);
    }

    public final void excludeInstrumentationName(@NotNull String excludeString) {
        Intrinsics.checkNotNullParameter((Object)excludeString, (String)"excludeString");
        this.getExcludedInstrumentationNames().add((Object)excludeString);
    }

    public final void skip(String ... version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.getSkipVersions().addAll((Object[])Arrays.copyOf(version, version.length));
    }

    @NotNull
    public final String getNameSlug$gradle_plugins() {
        Object object = this.getName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name.get()");
        String string = (String)object;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return NORMALIZE_NAME_SLUG.replace((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), "-");
    }

    @NotNull
    public final Set<String> getNormalizedSkipVersions$gradle_plugins() {
        boolean bl = false;
        Stream stream = ((Set)this.getSkipVersions().getOrElse((Object)SetsKt.emptySet())).stream();
        Object object = normalizedSkipVersions.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            };
        }
        Set<String> set = stream.map((Function)object).collect(Collectors.toSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"skipVersions.getOrElse(s\u2026llect(Collectors.toSet())");
        return set;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Object object = this.getCoreJdk$gradle_plugins().getOrElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"coreJdk.getOrElse(false)");
        if (((Boolean)object).booleanValue()) {
            Object object2 = this.getAssertPass().getOrElse((Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"assertPass.getOrElse(false)");
            if (((Boolean)object2).booleanValue()) {
                sb.append("Pass");
            } else {
                sb.append("Fail");
            }
            sb.append("-core-jdk");
        } else {
            Object object3 = this.getAssertPass().getOrElse((Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"assertPass.getOrElse(false)");
            if (((Boolean)object3).booleanValue()) {
                sb.append("pass");
            } else {
                sb.append("fail");
            }
            sb.append((String)this.getGroup().get()).append(':').append((String)this.getModule().get()).append(':').append((String)this.getVersions().get());
            if (this.getClassifier().isPresent()) {
                sb.append(':').append((String)this.getClassifier().get());
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public MuzzleDirective() {
        this.getName().convention((Object)"");
        this.getClassifier().convention((Object)"");
        this.getSkipVersions().convention((Iterable)SetsKt.emptySet());
        boolean bl = false;
        this.getAdditionalDependencies().convention((Iterable)CollectionsKt.emptyList());
        bl = false;
        this.getExcludedDependencies().convention((Iterable)CollectionsKt.emptyList());
        bl = false;
        this.getExcludedInstrumentationNames().convention((Iterable)CollectionsKt.emptyList());
        this.getAssertPass().convention((Object)false);
        this.getAssertInverse().convention((Object)false);
        this.getCoreJdk$gradle_plugins().convention((Object)false);
    }

    static {
        Companion = new Companion(null);
        NORMALIZE_NAME_SLUG = new Regex("[^a-zA-Z0-9]+");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/opentelemetry/javaagent/muzzle/MuzzleDirective$Companion;", "", "()V", "NORMALIZE_NAME_SLUG", "Lkotlin/text/Regex;", "gradle-plugins"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

