/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.muzzle.matcher;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lio/opentelemetry/javaagent/muzzle/matcher/MuzzleGradlePluginUtil;", "", "()V", "Companion", "gradle-plugins"})
public final class MuzzleGradlePluginUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lio/opentelemetry/javaagent/muzzle/matcher/MuzzleGradlePluginUtil$Companion;", "", "()V", "assertInstrumentationMuzzled", "", "agentClassLoader", "Ljava/lang/ClassLoader;", "userClassLoader", "excludedInstrumentationNames", "", "", "assertPass", "", "printMuzzleReferences", "instrumentationClassLoader", "gradle-plugins"})
    public static final class Companion {
        private Companion() {
        }

        public final void assertInstrumentationMuzzled(@NotNull ClassLoader agentClassLoader, @NotNull ClassLoader userClassLoader, @NotNull Set<String> excludedInstrumentationNames, boolean assertPass) {
            Intrinsics.checkNotNullParameter((Object)agentClassLoader, (String)"agentClassLoader");
            Intrinsics.checkNotNullParameter((Object)userClassLoader, (String)"userClassLoader");
            Intrinsics.checkNotNullParameter(excludedInstrumentationNames, (String)"excludedInstrumentationNames");
            Class<?> matcherClass = agentClassLoader.loadClass("io.opentelemetry.javaagent.tooling.muzzle.ClassLoaderMatcher");
            Object[] objectArray = new Class[]{ClassLoader.class, Boolean.TYPE, Set.class};
            Method method = matcherClass.getMethod("matchesAll", (Class<?>[])objectArray);
            objectArray = new Object[]{userClassLoader, assertPass, excludedInstrumentationNames};
            Object object = method.invoke(null, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.collections.List<kotlin.Any>>");
            Map allMismatches = (Map)object;
            allMismatches.forEach(new BiConsumer(assertPass){
                final /* synthetic */ boolean $assertPass;
                {
                    this.$assertPass = $assertPass;
                }

                public final void accept(@NotNull String moduleName, @NotNull List<? extends Object> mismatches) {
                    Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
                    Intrinsics.checkNotNullParameter(mismatches, (String)"mismatches");
                    boolean passed = mismatches.isEmpty();
                    if (passed && !this.$assertPass) {
                        System.err.println("MUZZLE PASSED " + moduleName + " BUT FAILURE WAS EXPECTED");
                        throw new IllegalStateException("Instrumentation unexpectedly passed Muzzle validation");
                    }
                    if (!passed && this.$assertPass) {
                        System.err.println("FAILED MUZZLE VALIDATION: " + moduleName + " mismatches:");
                        for (Object object : mismatches) {
                            System.err.println("-- " + object);
                        }
                        throw new IllegalStateException("Instrumentation failed Muzzle validation");
                    }
                }
            });
            int validatedModulesCount = allMismatches.size();
            if (validatedModulesCount == 0) {
                String errorMessage = "Did not find any InstrumentationModule(s) to validate!";
                System.err.println(errorMessage);
                throw new IllegalStateException(errorMessage);
            }
        }

        public final void printMuzzleReferences(@NotNull ClassLoader instrumentationClassLoader) {
            Intrinsics.checkNotNullParameter((Object)instrumentationClassLoader, (String)"instrumentationClassLoader");
            Class<?> matcherClass = instrumentationClassLoader.loadClass("io.opentelemetry.javaagent.tooling.muzzle.ReferencesPrinter");
            matcherClass.getMethod("printMuzzleReferences", new Class[0]).invoke(null, new Object[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

