/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.muzzle;

import io.opentelemetry.javaagent.muzzle.MuzzleDirective;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\b&\u0018\u0000 62\u00020\u0001:\u00016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\"\u001a\u00020$J\u000e\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0001J\u0010\u0010'\u001a\u00020$2\b\u0010(\u001a\u0004\u0018\u00010\u0006J\u000e\u0010)\u001a\u00020$2\u0006\u0010(\u001a\u00020\u0006J\u001f\u0010*\u001a\u00020$2\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060,\"\u00020\u0006\u00a2\u0006\u0002\u0010-J\b\u00105\u001a\u00020\u0006H\u0016R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014R\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\bR\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\bR\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0005X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\bR\u0014\u0010.\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u0006028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u00067"}, d2={"Lio/opentelemetry/javaagent/muzzle/MuzzleDirective;", "", "<init>", "()V", "name", "Lorg/gradle/api/provider/Property;", "", "getName", "()Lorg/gradle/api/provider/Property;", "group", "getGroup", "module", "getModule", "classifier", "getClassifier", "versions", "getVersions", "skipVersions", "Lorg/gradle/api/provider/SetProperty;", "getSkipVersions", "()Lorg/gradle/api/provider/SetProperty;", "additionalDependencies", "Lorg/gradle/api/provider/ListProperty;", "getAdditionalDependencies", "()Lorg/gradle/api/provider/ListProperty;", "excludedDependencies", "getExcludedDependencies", "excludedInstrumentationNames", "getExcludedInstrumentationNames", "assertPass", "", "getAssertPass", "assertInverse", "getAssertInverse", "coreJdk", "getCoreJdk$gradle_plugins", "", "extraDependency", "dependencyNotation", "excludeDependency", "excludeString", "excludeInstrumentationName", "skip", "version", "", "([Ljava/lang/String;)V", "nameSlug", "getNameSlug$gradle_plugins", "()Ljava/lang/String;", "normalizedSkipVersions", "", "getNormalizedSkipVersions$gradle_plugins", "()Ljava/util/Set;", "toString", "Companion", "gradle-plugins"})
public abstract class MuzzleDirective {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex NORMALIZE_NAME_SLUG = new Regex("[^a-zA-Z0-9]+");

    public MuzzleDirective() {
        this.getName().convention((Object)"");
        this.getClassifier().convention((Object)"");
        this.getSkipVersions().convention((Iterable)SetsKt.emptySet());
        this.getAdditionalDependencies().convention((Iterable)CollectionsKt.emptyList());
        this.getExcludedDependencies().convention((Iterable)CollectionsKt.emptyList());
        this.getExcludedInstrumentationNames().convention((Iterable)CollectionsKt.emptyList());
        this.getAssertPass().convention((Object)false);
        this.getAssertInverse().convention((Object)false);
        this.getCoreJdk$gradle_plugins().convention((Object)false);
    }

    @NotNull
    public abstract Property<String> getName();

    @NotNull
    public abstract Property<String> getGroup();

    @NotNull
    public abstract Property<String> getModule();

    @NotNull
    public abstract Property<String> getClassifier();

    @NotNull
    public abstract Property<String> getVersions();

    @NotNull
    public abstract SetProperty<String> getSkipVersions();

    @NotNull
    public abstract ListProperty<Object> getAdditionalDependencies();

    @NotNull
    public abstract ListProperty<String> getExcludedDependencies();

    @NotNull
    public abstract SetProperty<String> getExcludedInstrumentationNames();

    @NotNull
    public abstract Property<Boolean> getAssertPass();

    @NotNull
    public abstract Property<Boolean> getAssertInverse();

    @NotNull
    public abstract Property<Boolean> getCoreJdk$gradle_plugins();

    public final void coreJdk() {
        this.getCoreJdk$gradle_plugins().set((Object)true);
    }

    public final void extraDependency(@NotNull Object dependencyNotation) {
        Intrinsics.checkNotNullParameter((Object)dependencyNotation, (String)"dependencyNotation");
        this.getAdditionalDependencies().add(dependencyNotation);
    }

    public final void excludeDependency(@Nullable String excludeString) {
        ListProperty<String> listProperty = this.getExcludedDependencies();
        String string = excludeString;
        Intrinsics.checkNotNull((Object)string);
        listProperty.add((Object)string);
    }

    public final void excludeInstrumentationName(@NotNull String excludeString) {
        Intrinsics.checkNotNullParameter((Object)excludeString, (String)"excludeString");
        this.getExcludedInstrumentationNames().add((Object)excludeString);
    }

    public final void skip(String ... version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.getSkipVersions().addAll((Object[])Arrays.copyOf(version, version.length));
    }

    @NotNull
    public final String getNameSlug$gradle_plugins() {
        Object object = this.getName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return NORMALIZE_NAME_SLUG.replace((CharSequence)((Object)StringsKt.trim((CharSequence)((String)object))).toString(), "-");
    }

    @NotNull
    public final Set<String> getNormalizedSkipVersions$gradle_plugins() {
        Set<String> set = ((Set)this.getSkipVersions().getOrElse((Object)SetsKt.emptySet())).stream().map(normalizedSkipVersions.1.INSTANCE).collect(Collectors.toSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"collect(...)");
        return set;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (((Boolean)this.getCoreJdk$gradle_plugins().getOrElse((Object)false)).booleanValue()) {
            StringBuilder stringBuilder = (Boolean)this.getAssertPass().getOrElse((Object)false) != false ? sb.append("Pass") : sb.append("Fail");
            sb.append("-core-jdk");
        } else {
            StringBuilder stringBuilder = (Boolean)this.getAssertPass().getOrElse((Object)false) != false ? sb.append("pass") : sb.append("fail");
            sb.append((String)this.getGroup().get()).append(':').append((String)this.getModule().get()).append(':').append((String)this.getVersions().get());
            if (this.getClassifier().isPresent()) {
                sb.append(':').append((String)this.getClassifier().get());
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/opentelemetry/javaagent/muzzle/MuzzleDirective$Companion;", "", "<init>", "()V", "NORMALIZE_NAME_SLUG", "Lkotlin/text/Regex;", "gradle-plugins"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

