/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.apachehttpclient.v4_3;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientHttpAttributesGetter;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientNetAttributesGetter;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientRequest;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpResponse;

public final class ApacheHttpClientTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.apache-httpclient-4.3";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<? super ApacheHttpClientRequest, ? super HttpResponse>> additionalExtractors = new ArrayList<AttributesExtractor<? super ApacheHttpClientRequest, ? super HttpResponse>>();
    private final HttpClientAttributesExtractorBuilder<ApacheHttpClientRequest, HttpResponse> httpAttributesExtractorBuilder = HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)ApacheHttpClientHttpAttributesGetter.INSTANCE, (NetClientAttributesGetter)new ApacheHttpClientNetAttributesGetter());

    ApacheHttpClientTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public ApacheHttpClientTelemetryBuilder addAttributeExtractor(AttributesExtractor<? super ApacheHttpClientRequest, ? super HttpResponse> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public ApacheHttpClientTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public ApacheHttpClientTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    public ApacheHttpClientTelemetry build() {
        ApacheHttpClientHttpAttributesGetter httpAttributesGetter = ApacheHttpClientHttpAttributesGetter.INSTANCE;
        Instrumenter instrumenter = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)httpAttributesGetter)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addAttributesExtractor((AttributesExtractor)this.httpAttributesExtractorBuilder.build()).addAttributesExtractors(this.additionalExtractors).buildInstrumenter(SpanKindExtractor.alwaysClient());
        return new ApacheHttpClientTelemetry((Instrumenter<ApacheHttpClientRequest, HttpResponse>)instrumenter, this.openTelemetry.getPropagators());
    }
}

