/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.apachehttpclient.v4_3;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientRequest;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.HttpHeaderSetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.RedirectLocations;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.protocol.HttpContext;

final class TracingProtocolExec
implements ClientExecChain {
    private static final String REQUEST_CONTEXT_ATTRIBUTE_ID = TracingProtocolExec.class.getName() + ".context";
    private static final String REQUEST_WRAPPER_ATTRIBUTE_ID = TracingProtocolExec.class.getName() + ".requestWrapper";
    private static final String REDIRECT_COUNT_ATTRIBUTE_ID = TracingProtocolExec.class.getName() + ".redirectCount";
    private final Instrumenter<ApacheHttpClientRequest, HttpResponse> instrumenter;
    private final ContextPropagators propagators;
    private final ClientExecChain exec;

    TracingProtocolExec(Instrumenter<ApacheHttpClientRequest, HttpResponse> instrumenter, ContextPropagators propagators, ClientExecChain exec) {
        this.instrumenter = instrumenter;
        this.propagators = propagators;
        this.exec = exec;
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext httpContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        Context context = (Context)httpContext.getAttribute(REQUEST_CONTEXT_ATTRIBUTE_ID, Context.class);
        if (context != null) {
            ApacheHttpClientRequest instrumenterRequest = (ApacheHttpClientRequest)httpContext.getAttribute(REQUEST_WRAPPER_ATTRIBUTE_ID, ApacheHttpClientRequest.class);
            this.propagators.getTextMapPropagator().inject(context, (Object)request, (TextMapSetter)HttpHeaderSetter.INSTANCE);
            return this.execute(route, request, instrumenterRequest, httpContext, httpExecutionAware, context);
        }
        HttpHost host = null;
        if (route.getTargetHost() != null) {
            host = route.getTargetHost();
        } else if (httpContext.getTargetHost() != null) {
            host = httpContext.getTargetHost();
        }
        if (host != null && (host.getSchemeName().equals("https") && host.getPort() == 443 || host.getSchemeName().equals("http") && host.getPort() == 80)) {
            host = new HttpHost(host.getHostName(), -1, host.getSchemeName());
        }
        ApacheHttpClientRequest instrumenterRequest = new ApacheHttpClientRequest(host, (HttpRequest)request);
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)instrumenterRequest)) {
            return this.exec.execute(route, request, httpContext, httpExecutionAware);
        }
        context = this.instrumenter.start(parentContext, (Object)instrumenterRequest);
        httpContext.setAttribute(REQUEST_CONTEXT_ATTRIBUTE_ID, (Object)context);
        httpContext.setAttribute(REQUEST_WRAPPER_ATTRIBUTE_ID, (Object)instrumenterRequest);
        httpContext.setAttribute(REDIRECT_COUNT_ATTRIBUTE_ID, (Object)0);
        this.propagators.getTextMapPropagator().inject(context, (Object)request, (TextMapSetter)HttpHeaderSetter.INSTANCE);
        return this.execute(route, request, instrumenterRequest, httpContext, httpExecutionAware, context);
    }

    private CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, ApacheHttpClientRequest instrumenterRequest, HttpClientContext httpContext, HttpExecutionAware httpExecutionAware, Context context) throws IOException, HttpException {
        CloseableHttpResponse response = null;
        Throwable error = null;
        try {
            CloseableHttpResponse closeableHttpResponse;
            block12: {
                Scope ignored = context.makeCurrent();
                try {
                    closeableHttpResponse = response = this.exec.execute(route, request, httpContext, httpExecutionAware);
                    if (ignored == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        error = e;
                        throw e;
                    }
                }
                ignored.close();
            }
            return closeableHttpResponse;
        }
        finally {
            if (!this.pendingRedirect(context, httpContext, request, instrumenterRequest, response)) {
                this.instrumenter.end(context, (Object)instrumenterRequest, (Object)response, error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pendingRedirect(Context context, HttpClientContext httpContext, HttpRequestWrapper request, ApacheHttpClientRequest instrumenterRequest, @Nullable CloseableHttpResponse response) {
        if (response == null) {
            return false;
        }
        if (!httpContext.getRequestConfig().isRedirectsEnabled()) {
            return false;
        }
        try {
            if (!DefaultRedirectStrategy.INSTANCE.isRedirected((HttpRequest)request, (HttpResponse)response, (HttpContext)httpContext)) {
                return false;
            }
        }
        catch (ProtocolException e) {
            return false;
        }
        RedirectLocations redirectLocations = (RedirectLocations)httpContext.getAttribute("http.protocol.redirect-locations");
        if (redirectLocations != null) {
            RedirectLocations copy = new RedirectLocations();
            copy.addAll((Collection)redirectLocations);
            try {
                DefaultRedirectStrategy.INSTANCE.getLocationURI((HttpRequest)request, (HttpResponse)response, (HttpContext)httpContext);
            }
            catch (ProtocolException e) {
                this.instrumenter.end(context, (Object)instrumenterRequest, (Object)response, (Throwable)new ClientProtocolException((Throwable)e));
                boolean bl = true;
                return bl;
            }
            finally {
                httpContext.setAttribute("http.protocol.redirect-locations", (Object)copy);
            }
        }
        int redirectCount = (Integer)httpContext.getAttribute(REDIRECT_COUNT_ATTRIBUTE_ID, Integer.class);
        if (++redirectCount > httpContext.getRequestConfig().getMaxRedirects()) {
            return false;
        }
        httpContext.setAttribute(REDIRECT_COUNT_ATTRIBUTE_ID, (Object)redirectCount);
        return true;
    }
}

