/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.apachehttpclient.v5_2;

import io.opentelemetry.instrumentation.apachehttpclient.v5_2.ApacheHttpClient5Request;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolVersion;

enum ApacheHttpClient5HttpAttributesGetter implements HttpClientAttributesGetter<ApacheHttpClient5Request, HttpResponse>
{
    INSTANCE;


    public String getHttpRequestMethod(ApacheHttpClient5Request request) {
        return request.getMethod();
    }

    @Nullable
    public String getUrlFull(ApacheHttpClient5Request request) {
        return request.getUrl();
    }

    public List<String> getHttpRequestHeader(ApacheHttpClient5Request request, String name) {
        return ApacheHttpClient5HttpAttributesGetter.getHeader(request, name);
    }

    public Integer getHttpResponseStatusCode(ApacheHttpClient5Request request, HttpResponse response, @Nullable Throwable error) {
        return response.getCode();
    }

    public List<String> getHttpResponseHeader(ApacheHttpClient5Request request, HttpResponse response, String name) {
        return ApacheHttpClient5HttpAttributesGetter.getHeader((MessageHeaders)response, name);
    }

    private static List<String> getHeader(MessageHeaders messageHeaders, String name) {
        return ApacheHttpClient5HttpAttributesGetter.headersToList(messageHeaders.getHeaders(name));
    }

    private static List<String> getHeader(ApacheHttpClient5Request messageHeaders, String name) {
        return ApacheHttpClient5HttpAttributesGetter.headersToList(messageHeaders.getDelegate().getHeaders(name));
    }

    private static List<String> headersToList(Header[] headers) {
        if (headers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> headersList = new ArrayList<String>(headers.length);
        for (Header header : headers) {
            headersList.add(header.getValue());
        }
        return headersList;
    }

    @Nullable
    public String getNetworkProtocolName(ApacheHttpClient5Request request, @Nullable HttpResponse response) {
        ProtocolVersion protocolVersion = ApacheHttpClient5HttpAttributesGetter.getVersion(request, response);
        if (protocolVersion == null) {
            return null;
        }
        return protocolVersion.getProtocol();
    }

    @Nullable
    public String getNetworkProtocolVersion(ApacheHttpClient5Request request, @Nullable HttpResponse response) {
        ProtocolVersion protocolVersion = ApacheHttpClient5HttpAttributesGetter.getVersion(request, response);
        if (protocolVersion == null) {
            return null;
        }
        if (protocolVersion.getMinor() == 0) {
            return Integer.toString(protocolVersion.getMajor());
        }
        return protocolVersion.getMajor() + "." + protocolVersion.getMinor();
    }

    @Nullable
    public String getServerAddress(ApacheHttpClient5Request request) {
        return request.getDelegate().getAuthority().getHostName();
    }

    public Integer getServerPort(ApacheHttpClient5Request request) {
        return request.getDelegate().getAuthority().getPort();
    }

    private static ProtocolVersion getVersion(ApacheHttpClient5Request request, @Nullable HttpResponse response) {
        ProtocolVersion protocolVersion = request.getDelegate().getVersion();
        if (protocolVersion == null && response != null) {
            protocolVersion = response.getVersion();
        }
        return protocolVersion;
    }
}

