/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.apachehttpclient.v5_2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;

public final class ApacheHttpClientRequest {
    private static final Logger logger = Logger.getLogger(ApacheHttpClientRequest.class.getName());
    @Nullable
    private final URI uri;
    private final HttpRequest delegate;

    ApacheHttpClientRequest(@Nullable HttpHost httpHost, HttpRequest httpRequest) {
        URI calculatedUri = ApacheHttpClientRequest.getUri(httpRequest);
        this.uri = calculatedUri != null && httpHost != null ? ApacheHttpClientRequest.getCalculatedUri(httpHost, calculatedUri) : calculatedUri;
        this.delegate = httpRequest;
    }

    public HttpRequest getDelegate() {
        return this.delegate;
    }

    String getMethod() {
        return this.delegate.getMethod();
    }

    @Nullable
    String getUrl() {
        return this.uri != null ? this.uri.toString() : null;
    }

    @Nullable
    private static URI getUri(HttpRequest httpRequest) {
        try {
            return new URI(httpRequest.getUri().toString());
        }
        catch (URISyntaxException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return null;
        }
    }

    @Nullable
    private static URI getCalculatedUri(HttpHost httpHost, URI uri) {
        try {
            return new URI(httpHost.getSchemeName(), uri.getUserInfo(), httpHost.getHostName(), httpHost.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return null;
        }
    }
}

