/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.apachehttpclient.v5_2;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolVersion;

final class ApacheHttpClient5Request {
    private static final Logger logger = Logger.getLogger(ApacheHttpClient5Request.class.getName());
    @Nullable
    private final URI uri;
    private final HttpRequest delegate;
    @Nullable
    private final HttpHost target;

    ApacheHttpClient5Request(@Nullable HttpHost httpHost, HttpRequest httpRequest) {
        URI calculatedUri = ApacheHttpClient5Request.getUri(httpRequest);
        this.uri = calculatedUri != null && httpHost != null ? ApacheHttpClient5Request.getCalculatedUri(httpHost, calculatedUri) : calculatedUri;
        this.delegate = httpRequest;
        this.target = httpHost;
    }

    public HttpRequest getDelegate() {
        return this.delegate;
    }

    List<String> getHeader(String name) {
        return ApacheHttpClient5Request.headersToList(this.delegate.getHeaders(name));
    }

    static List<String> headersToList(Header[] headers) {
        if (headers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> headersList = new ArrayList<String>(headers.length);
        for (Header header : headers) {
            headersList.add(header.getValue());
        }
        return headersList;
    }

    void setHeader(String name, String value) {
        this.delegate.setHeader(name, (Object)value);
    }

    String getMethod() {
        return this.delegate.getMethod();
    }

    @Nullable
    String getUrl() {
        return this.uri != null ? this.uri.toString() : null;
    }

    String getProtocolName() {
        return this.delegate.getVersion().getProtocol();
    }

    String getProtocolVersion() {
        ProtocolVersion protocolVersion = this.delegate.getVersion();
        if (protocolVersion.getMinor() == 0) {
            return Integer.toString(protocolVersion.getMajor());
        }
        return protocolVersion.getMajor() + "." + protocolVersion.getMinor();
    }

    @Nullable
    public String getServerAddress() {
        return this.uri == null ? null : this.uri.getHost();
    }

    @Nullable
    public Integer getServerPort() {
        return this.uri == null ? null : Integer.valueOf(this.uri.getPort());
    }

    @Nullable
    private static URI getUri(HttpRequest httpRequest) {
        try {
            return new URI(httpRequest.getUri().toString());
        }
        catch (URISyntaxException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return null;
        }
    }

    @Nullable
    private static URI getCalculatedUri(HttpHost httpHost, URI uri) {
        try {
            return new URI(httpHost.getSchemeName(), uri.getUserInfo(), httpHost.getHostName(), httpHost.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return null;
        }
    }

    @Nullable
    public InetSocketAddress getServerSocketAddress() {
        if (this.target == null) {
            return null;
        }
        InetAddress inetAddress = this.target.getAddress();
        return inetAddress == null ? null : new InetSocketAddress(inetAddress, this.target.getPort());
    }
}

