/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.apachehttpclient.v5_2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.apachehttpclient.v5_2.ApacheHttpClient5HttpAttributesGetter;
import io.opentelemetry.instrumentation.apachehttpclient.v5_2.ApacheHttpClient5Request;
import io.opentelemetry.instrumentation.apachehttpclient.v5_2.ApacheHttpClient5Telemetry;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpClientExperimentalMetrics;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanStatusExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hc.core5.http.HttpResponse;

public final class ApacheHttpClient5TelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.apache-httpclient-5.2";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<? super ApacheHttpClient5Request, ? super HttpResponse>> additionalExtractors = new ArrayList<AttributesExtractor<? super ApacheHttpClient5Request, ? super HttpResponse>>();
    private final HttpClientAttributesExtractorBuilder<ApacheHttpClient5Request, HttpResponse> httpAttributesExtractorBuilder = HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)ApacheHttpClient5HttpAttributesGetter.INSTANCE);
    private final HttpSpanNameExtractorBuilder<ApacheHttpClient5Request> httpSpanNameExtractorBuilder = HttpSpanNameExtractor.builder((HttpClientAttributesGetter)ApacheHttpClient5HttpAttributesGetter.INSTANCE);
    private boolean emitExperimentalHttpClientMetrics = false;

    ApacheHttpClient5TelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public ApacheHttpClient5TelemetryBuilder addAttributeExtractor(AttributesExtractor<? super ApacheHttpClient5Request, ? super HttpResponse> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public ApacheHttpClient5TelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public ApacheHttpClient5TelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public ApacheHttpClient5TelemetryBuilder setKnownMethods(Set<String> knownMethods) {
        this.httpAttributesExtractorBuilder.setKnownMethods(knownMethods);
        this.httpSpanNameExtractorBuilder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public ApacheHttpClient5TelemetryBuilder setEmitExperimentalHttpClientMetrics(boolean emitExperimentalHttpClientMetrics) {
        this.emitExperimentalHttpClientMetrics = emitExperimentalHttpClientMetrics;
        return this;
    }

    public ApacheHttpClient5Telemetry build() {
        ApacheHttpClient5HttpAttributesGetter httpAttributesGetter = ApacheHttpClient5HttpAttributesGetter.INSTANCE;
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)this.httpSpanNameExtractorBuilder.build()).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addAttributesExtractor(this.httpAttributesExtractorBuilder.build()).addAttributesExtractors(this.additionalExtractors).addOperationMetrics(HttpClientMetrics.get());
        if (this.emitExperimentalHttpClientMetrics) {
            builder.addAttributesExtractor(HttpExperimentalAttributesExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addOperationMetrics(HttpClientExperimentalMetrics.get());
        }
        Instrumenter instrumenter = builder.buildInstrumenter(SpanKindExtractor.alwaysClient());
        return new ApacheHttpClient5Telemetry((Instrumenter<ApacheHttpClient5Request, HttpResponse>)instrumenter, this.openTelemetry.getPropagators());
    }
}

