/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.handlers.RequestHandler2;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.contrib.awsxray.propagator.AwsXrayPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awssdk.v1_11.HeaderSetter;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsMessageAccess;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsParentContext;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsReceiveMessageRequestAccess;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsReceiveMessageResultAccess;
import java.util.List;
import javax.annotation.Nullable;

final class TracingRequestHandler
extends RequestHandler2 {
    static final HandlerContextKey<Context> CONTEXT = new HandlerContextKey(Context.class.getName());
    private final Instrumenter<Request<?>, Response<?>> requestInstrumenter;
    private final Instrumenter<Request<?>, Response<?>> consumerInstrumenter;

    TracingRequestHandler(Instrumenter<Request<?>, Response<?>> requestInstrumenter, Instrumenter<Request<?>, Response<?>> consumerInstrumenter) {
        this.requestInstrumenter = requestInstrumenter;
        this.consumerInstrumenter = consumerInstrumenter;
    }

    public void beforeRequest(Request<?> request) {
        Context parentContext = Context.current();
        if (!this.requestInstrumenter.shouldStart(parentContext, request)) {
            return;
        }
        Context context = this.requestInstrumenter.start(parentContext, request);
        AwsXrayPropagator.getInstance().inject(context, request, (TextMapSetter)HeaderSetter.INSTANCE);
        request.addHandlerContext(CONTEXT, (Object)context);
    }

    public AmazonWebServiceRequest beforeMarshalling(AmazonWebServiceRequest request) {
        if (SqsReceiveMessageRequestAccess.isInstance(request) && !SqsReceiveMessageRequestAccess.getAttributeNames(request).contains("AWSTraceHeader")) {
            SqsReceiveMessageRequestAccess.withAttributeNames(request, "AWSTraceHeader");
        }
        return request;
    }

    public void afterResponse(Request<?> request, Response<?> response) {
        if (SqsReceiveMessageRequestAccess.isInstance(request.getOriginalRequest())) {
            this.afterConsumerResponse(request, response);
        }
        this.finish(request, response, null);
    }

    private void afterConsumerResponse(Request<?> request, Response<?> response) {
        Object receiveMessageResult = response.getAwsResponse();
        List<?> messages = SqsReceiveMessageResultAccess.getMessages(receiveMessageResult);
        for (Object message : messages) {
            this.createConsumerSpan(message, request, response);
        }
    }

    private void createConsumerSpan(Object message, Request<?> request, Response<?> response) {
        Context parentContext = SqsParentContext.ofSystemAttributes(SqsMessageAccess.getAttributes(message));
        Context context = this.consumerInstrumenter.start(parentContext, request);
        this.consumerInstrumenter.end(context, request, response, null);
    }

    public void afterError(Request<?> request, Response<?> response, Exception e) {
        this.finish(request, response, e);
    }

    private void finish(Request<?> request, Response<?> response, @Nullable Throwable error) {
        Context context = (Context)request.getHandlerContext(CONTEXT);
        if (context == null) {
            return;
        }
        request.addHandlerContext(CONTEXT, null);
        this.requestInstrumenter.end(context, request, response, error);
    }
}

