/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.Request;
import com.amazonaws.Response;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcClientAttributesExtractor;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkHttpAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkRpcAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkSpanKindExtractor;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkSpanNameExtractor;
import java.util.Arrays;
import java.util.List;

final class AwsSdkInstrumenterFactory {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.aws-sdk-1.11";
    private static final AttributesExtractor<Request<?>, Response<?>> httpAttributesExtractor = HttpClientAttributesExtractor.create((HttpClientAttributesGetter)new AwsSdkHttpAttributesGetter());
    private static final AttributesExtractor<Request<?>, Response<?>> rpcAttributesExtractor = RpcClientAttributesExtractor.create((RpcAttributesGetter)AwsSdkRpcAttributesGetter.INSTANCE);
    private static final AwsSdkExperimentalAttributesExtractor experimentalAttributesExtractor = new AwsSdkExperimentalAttributesExtractor();
    private static final AwsSdkSpanKindExtractor spanKindExtractor = new AwsSdkSpanKindExtractor();
    private static final List<AttributesExtractor<Request<?>, Response<?>>> defaultAttributesExtractors = Arrays.asList(httpAttributesExtractor, rpcAttributesExtractor);
    private static final List<AttributesExtractor<Request<?>, Response<?>>> extendedAttributesExtractors = Arrays.asList(httpAttributesExtractor, rpcAttributesExtractor, experimentalAttributesExtractor);
    private static final AwsSdkSpanNameExtractor spanName = new AwsSdkSpanNameExtractor();

    static Instrumenter<Request<?>, Response<?>> requestInstrumenter(OpenTelemetry openTelemetry, boolean captureExperimentalSpanAttributes) {
        return AwsSdkInstrumenterFactory.createInstrumenter(openTelemetry, captureExperimentalSpanAttributes, spanKindExtractor);
    }

    static Instrumenter<Request<?>, Response<?>> consumerInstrumenter(OpenTelemetry openTelemetry, boolean captureExperimentalSpanAttributes) {
        return AwsSdkInstrumenterFactory.createInstrumenter(openTelemetry, captureExperimentalSpanAttributes, SpanKindExtractor.alwaysConsumer());
    }

    private static Instrumenter<Request<?>, Response<?>> createInstrumenter(OpenTelemetry openTelemetry, boolean captureExperimentalSpanAttributes, SpanKindExtractor<Request<?>> kindExtractor) {
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)spanName).addAttributesExtractors(captureExperimentalSpanAttributes ? extendedAttributesExtractors : defaultAttributesExtractors).buildInstrumenter(kindExtractor);
    }

    private AwsSdkInstrumenterFactory() {
    }
}

