/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.Request;
import com.amazonaws.Response;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientMetrics;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingSpanNameExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v1_11.AbstractSqsRequest;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkAttributesExtractor;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkHttpAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkRpcAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkSpanNameExtractor;
import io.opentelemetry.instrumentation.awssdk.v1_11.DynamoDbAttributesExtractor;
import io.opentelemetry.instrumentation.awssdk.v1_11.SnsAttributesExtractor;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsParentContext;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsProcessRequest;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsProcessRequestAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsReceiveRequest;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsReceiveRequestAttributesGetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

final class AwsSdkInstrumenterFactory {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.aws-sdk-1.11";
    private static final AttributesExtractor<Request<?>, Response<?>> httpAttributesExtractor = HttpClientAttributesExtractor.create((HttpClientAttributesGetter)new AwsSdkHttpAttributesGetter());
    private static final AttributesExtractor<Request<?>, Response<?>> rpcAttributesExtractor = RpcClientAttributesExtractor.create((RpcAttributesGetter)AwsSdkRpcAttributesGetter.INSTANCE);
    private static final AwsSdkExperimentalAttributesExtractor experimentalAttributesExtractor = new AwsSdkExperimentalAttributesExtractor();
    private static final AwsSdkAttributesExtractor sdkAttributesExtractor = new AwsSdkAttributesExtractor();
    private static final SnsAttributesExtractor snsAttributesExtractor = new SnsAttributesExtractor();
    private static final List<AttributesExtractor<Request<?>, Response<?>>> defaultAttributesExtractors = AwsSdkInstrumenterFactory.createAttributesExtractors(false);
    private static final List<AttributesExtractor<Request<?>, Response<?>>> extendedAttributesExtractors = AwsSdkInstrumenterFactory.createAttributesExtractors(true);
    private static final AwsSdkSpanNameExtractor spanName = new AwsSdkSpanNameExtractor();
    private final OpenTelemetry openTelemetry;
    private final List<String> capturedHeaders;
    private final boolean captureExperimentalSpanAttributes;
    private final boolean messagingReceiveInstrumentationEnabled;

    AwsSdkInstrumenterFactory(OpenTelemetry openTelemetry, List<String> capturedHeaders, boolean captureExperimentalSpanAttributes, boolean messagingReceiveInstrumentationEnabled) {
        this.openTelemetry = openTelemetry;
        this.capturedHeaders = capturedHeaders;
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        this.messagingReceiveInstrumentationEnabled = messagingReceiveInstrumentationEnabled;
    }

    private static List<AttributesExtractor<Request<?>, Response<?>>> createAttributesExtractors(boolean includeExperimental) {
        ArrayList extractors = new ArrayList(Arrays.asList(httpAttributesExtractor, rpcAttributesExtractor, snsAttributesExtractor, sdkAttributesExtractor));
        if (includeExperimental) {
            extractors.add(experimentalAttributesExtractor);
        }
        return extractors;
    }

    Instrumenter<Request<?>, Response<?>> requestInstrumenter() {
        return AwsSdkInstrumenterFactory.createInstrumenter(this.openTelemetry, spanName, SpanKindExtractor.alwaysClient(), this.attributesExtractors(), Collections.emptyList(), true);
    }

    private List<AttributesExtractor<Request<?>, Response<?>>> attributesExtractors() {
        return this.captureExperimentalSpanAttributes ? extendedAttributesExtractors : defaultAttributesExtractors;
    }

    private <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> messagingAttributesExtractor(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation) {
        return MessagingAttributesExtractor.builder(getter, (MessageOperation)operation).setCapturedHeaders(this.capturedHeaders).build();
    }

    Instrumenter<SqsReceiveRequest, Response<?>> consumerReceiveInstrumenter() {
        MessageOperation operation = MessageOperation.RECEIVE;
        SqsReceiveRequestAttributesGetter getter = SqsReceiveRequestAttributesGetter.INSTANCE;
        AttributesExtractor messagingAttributeExtractor = this.messagingAttributesExtractor(getter, operation);
        return AwsSdkInstrumenterFactory.createInstrumenter(this.openTelemetry, MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation), SpanKindExtractor.alwaysConsumer(), AwsSdkInstrumenterFactory.toSqsRequestExtractors(this.attributesExtractors()), Collections.singletonList(messagingAttributeExtractor), this.messagingReceiveInstrumentationEnabled);
    }

    Instrumenter<SqsProcessRequest, Response<?>> consumerProcessInstrumenter() {
        MessageOperation operation = MessageOperation.PROCESS;
        SqsProcessRequestAttributesGetter getter = SqsProcessRequestAttributesGetter.INSTANCE;
        AttributesExtractor messagingAttributeExtractor = this.messagingAttributesExtractor(getter, operation);
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractors(AwsSdkInstrumenterFactory.toSqsRequestExtractors(this.attributesExtractors())).addAttributesExtractor(messagingAttributeExtractor);
        if (this.messagingReceiveInstrumentationEnabled) {
            builder.addSpanLinksExtractor((spanLinks, parentContext, request) -> {
                Context extracted = SqsParentContext.ofSystemAttributes(request.getMessage().getAttributes());
                spanLinks.addLink(Span.fromContext((Context)extracted).getSpanContext());
            });
        }
        return builder.buildInstrumenter(SpanKindExtractor.alwaysConsumer());
    }

    private static List<AttributesExtractor<AbstractSqsRequest, Response<?>>> toSqsRequestExtractors(List<AttributesExtractor<Request<?>, Response<?>>> extractors) {
        ArrayList result = new ArrayList();
        for (final AttributesExtractor<Request<?>, Response<?>> extractor : extractors) {
            result.add(new AttributesExtractor<AbstractSqsRequest, Response<?>>(){

                public void onStart(AttributesBuilder attributes, Context parentContext, AbstractSqsRequest sqsRequest) {
                    extractor.onStart(attributes, parentContext, sqsRequest.getRequest());
                }

                public void onEnd(AttributesBuilder attributes, Context context, AbstractSqsRequest sqsRequest, @Nullable Response<?> response, @Nullable Throwable error) {
                    extractor.onEnd(attributes, context, sqsRequest.getRequest(), response, error);
                }
            });
        }
        return result;
    }

    Instrumenter<Request<?>, Response<?>> producerInstrumenter() {
        MessageOperation operation = MessageOperation.PUBLISH;
        SqsAttributesGetter getter = SqsAttributesGetter.INSTANCE;
        AttributesExtractor messagingAttributeExtractor = this.messagingAttributesExtractor(getter, operation);
        return AwsSdkInstrumenterFactory.createInstrumenter(this.openTelemetry, MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation), SpanKindExtractor.alwaysProducer(), this.attributesExtractors(), Collections.singletonList(messagingAttributeExtractor), true);
    }

    Instrumenter<Request<?>, Response<?>> dynamoDbInstrumenter() {
        DynamoDbAttributesExtractor dynamoDbAttributesExtractor = new DynamoDbAttributesExtractor();
        return Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)spanName).addAttributesExtractors(this.attributesExtractors()).addAttributesExtractors(Collections.singletonList(dynamoDbAttributesExtractor)).addOperationMetrics(DbClientMetrics.get()).buildInstrumenter(SpanKindExtractor.alwaysClient());
    }

    private static <REQUEST, RESPONSE> Instrumenter<REQUEST, RESPONSE> createInstrumenter(OpenTelemetry openTelemetry, SpanNameExtractor<REQUEST> spanNameExtractor, SpanKindExtractor<REQUEST> spanKindExtractor, List<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributeExtractors, List<AttributesExtractor<REQUEST, RESPONSE>> additionalAttributeExtractors, boolean enabled) {
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, spanNameExtractor).addAttributesExtractors(attributeExtractors).addAttributesExtractors(additionalAttributeExtractors).setEnabled(enabled).buildInstrumenter(spanKindExtractor);
    }
}

