/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.Request;
import com.amazonaws.Response;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.awssdk.v1_11.RequestAccess;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class DynamoDbAttributesExtractor
implements AttributesExtractor<Request<?>, Response<?>> {
    private static final AttributeKey<String> DB_SYSTEM = AttributeKey.stringKey((String)"db.system");
    private static final AttributeKey<List<String>> AWS_DYNAMODB_TABLE_NAMES = AttributeKey.stringArrayKey((String)"aws.dynamodb.table_names");
    private static final String DYNAMODB = "dynamodb";

    public void onStart(AttributesBuilder attributes, Context parentContext, Request<?> request) {
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_SYSTEM, (Object)DYNAMODB);
        String tableName = RequestAccess.getTableName(request.getOriginalRequest());
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, AWS_DYNAMODB_TABLE_NAMES, Collections.singletonList(tableName));
    }

    public void onEnd(AttributesBuilder attributes, Context context, Request<?> request, @Nullable Response<?> response, @Nullable Throwable error) {
    }
}

