/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.Request;
import com.amazonaws.Response;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.awssdk.v1_11.RequestAccess;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class DynamoDbAttributesExtractor
implements AttributesExtractor<Request<?>, Response<?>> {
    private static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey((String)"db.operation");
    private static final AttributeKey<String> DB_OPERATION_NAME = AttributeKey.stringKey((String)"db.operation.name");
    private static final AttributeKey<String> DB_SYSTEM = AttributeKey.stringKey((String)"db.system");
    private static final AttributeKey<String> DB_SYSTEM_NAME = AttributeKey.stringKey((String)"db.system.name");
    private static final AttributeKey<List<String>> AWS_DYNAMODB_TABLE_NAMES = AttributeKey.stringArrayKey((String)"aws.dynamodb.table_names");
    private static final String DYNAMODB = "dynamodb";
    private static final String AWS_DYNAMODB = "aws.dynamodb";

    DynamoDbAttributesExtractor() {
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, Request<?> request) {
        String operation;
        if (SemconvStability.emitStableDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_SYSTEM_NAME, (Object)AWS_DYNAMODB);
        }
        if (SemconvStability.emitOldDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_SYSTEM, (Object)DYNAMODB);
        }
        if ((operation = DynamoDbAttributesExtractor.getOperationName(request.getOriginalRequest())) != null) {
            if (SemconvStability.emitStableDatabaseSemconv()) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_OPERATION_NAME, (Object)operation);
            }
            if (SemconvStability.emitOldDatabaseSemconv()) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_OPERATION, (Object)operation);
            }
        }
        String tableName = RequestAccess.getTableName(request.getOriginalRequest());
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, AWS_DYNAMODB_TABLE_NAMES, Collections.singletonList(tableName));
    }

    private static String getOperationName(Object request) {
        String name = request.getClass().getSimpleName();
        if (!name.endsWith("Request")) {
            return null;
        }
        return name.substring(0, name.length() - "Request".length());
    }

    public void onEnd(AttributesBuilder attributes, Context context, Request<?> request, @Nullable Response<?> response, @Nullable Throwable error) {
    }
}

