/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.tooling.muzzle.NoMuzzle;
import javax.annotation.Nullable;

class AwsSdkAttributesExtractor
implements AttributesExtractor<Request<?>, Response<?>> {
    private static final boolean CAN_GET_RESPONSE_METADATA = AwsSdkAttributesExtractor.canGetResponseMetadata();
    private static final AttributeKey<String> AWS_REQUEST_ID = AttributeKey.stringKey((String)"aws.request_id");

    AwsSdkAttributesExtractor() {
    }

    private static boolean canGetResponseMetadata() {
        try {
            Class<?> clazz = Class.forName("com.amazonaws.AmazonWebServiceResult");
            clazz.getMethod("getSdkResponseMetadata", new Class[0]);
            return true;
        }
        catch (ClassNotFoundException | NoSuchMethodException exception) {
            return false;
        }
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, Request<?> request) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, Request<?> request, @Nullable Response<?> response, @Nullable Throwable error) {
        String requestId;
        ResponseMetadata responseMetadata = AwsSdkAttributesExtractor.getResponseMetadata(response);
        if (responseMetadata != null && (requestId = responseMetadata.getRequestId()) != null) {
            attributes.put(AWS_REQUEST_ID, (Object)requestId);
        }
    }

    @NoMuzzle
    private static ResponseMetadata getResponseMetadata(Response<?> response) {
        if (CAN_GET_RESPONSE_METADATA && response != null && response.getAwsResponse() instanceof AmazonWebServiceResult) {
            AmazonWebServiceResult awsResp = (AmazonWebServiceResult)response.getAwsResponse();
            return awsResp.getSdkResponseMetadata();
        }
        return null;
    }
}

