/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.annotation.Nullable;

final class RequestAccess {
    private static final String STEP_FUNCTIONS_REQUEST_CLASS_PREFIX = "com.amazonaws.services.stepfunctions.model.";
    private static final ClassValue<RequestAccess> REQUEST_ACCESSORS = new ClassValue<RequestAccess>(){

        @Override
        protected RequestAccess computeValue(Class<?> type) {
            return new RequestAccess(type);
        }
    };
    @Nullable
    private final MethodHandle getBucketName;
    @Nullable
    private final MethodHandle getQueueUrl;
    @Nullable
    private final MethodHandle getQueueName;
    @Nullable
    private final MethodHandle getStreamName;
    @Nullable
    private final MethodHandle getTableName;
    @Nullable
    private final MethodHandle getTopicArn;
    @Nullable
    private final MethodHandle getTargetArn;
    @Nullable
    private final MethodHandle getStateMachineArn;
    @Nullable
    private final MethodHandle getStepFunctionsActivityArn;

    @Nullable
    static String getStepFunctionsActivityArn(Object request) {
        if (request == null) {
            return null;
        }
        RequestAccess access = REQUEST_ACCESSORS.get(request.getClass());
        return RequestAccess.invokeOrNull(access.getStepFunctionsActivityArn, request);
    }

    @Nullable
    static String getStateMachineArn(Object request) {
        if (request == null) {
            return null;
        }
        RequestAccess access = REQUEST_ACCESSORS.get(request.getClass());
        return RequestAccess.invokeOrNull(access.getStateMachineArn, request);
    }

    @Nullable
    static String getBucketName(Object request) {
        RequestAccess access = REQUEST_ACCESSORS.get(request.getClass());
        return RequestAccess.invokeOrNull(access.getBucketName, request);
    }

    @Nullable
    static String getQueueUrl(Object request) {
        RequestAccess access = REQUEST_ACCESSORS.get(request.getClass());
        return RequestAccess.invokeOrNull(access.getQueueUrl, request);
    }

    @Nullable
    static String getQueueName(Object request) {
        RequestAccess access = REQUEST_ACCESSORS.get(request.getClass());
        return RequestAccess.invokeOrNull(access.getQueueName, request);
    }

    @Nullable
    static String getStreamName(Object request) {
        RequestAccess access = REQUEST_ACCESSORS.get(request.getClass());
        return RequestAccess.invokeOrNull(access.getStreamName, request);
    }

    @Nullable
    static String getTableName(Object request) {
        RequestAccess access = REQUEST_ACCESSORS.get(request.getClass());
        return RequestAccess.invokeOrNull(access.getTableName, request);
    }

    @Nullable
    static String getTopicArn(Object request) {
        RequestAccess access = REQUEST_ACCESSORS.get(request.getClass());
        return RequestAccess.invokeOrNull(access.getTopicArn, request);
    }

    @Nullable
    static String getTargetArn(Object request) {
        RequestAccess access = REQUEST_ACCESSORS.get(request.getClass());
        return RequestAccess.invokeOrNull(access.getTargetArn, request);
    }

    @Nullable
    private static String invokeOrNull(@Nullable MethodHandle method, Object obj) {
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(obj);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private RequestAccess(Class<?> clz) {
        this.getBucketName = RequestAccess.findAccessorOrNull(clz, "getBucketName");
        this.getQueueUrl = RequestAccess.findAccessorOrNull(clz, "getQueueUrl");
        this.getQueueName = RequestAccess.findAccessorOrNull(clz, "getQueueName");
        this.getStreamName = RequestAccess.findAccessorOrNull(clz, "getStreamName");
        this.getTableName = RequestAccess.findAccessorOrNull(clz, "getTableName");
        this.getTopicArn = RequestAccess.findAccessorOrNull(clz, "getTopicArn");
        this.getTargetArn = RequestAccess.findAccessorOrNull(clz, "getTargetArn");
        boolean isStepFunction = clz.getName().startsWith(STEP_FUNCTIONS_REQUEST_CLASS_PREFIX);
        this.getStateMachineArn = isStepFunction ? RequestAccess.findAccessorOrNull(clz, "getStateMachineArn") : null;
        this.getStepFunctionsActivityArn = isStepFunction ? RequestAccess.findAccessorOrNull(clz, "getActivityArn") : null;
    }

    @Nullable
    private static MethodHandle findAccessorOrNull(Class<?> clz, String methodName) {
        try {
            return MethodHandles.publicLookup().findVirtual(clz, methodName, MethodType.methodType(String.class));
        }
        catch (Throwable t) {
            return null;
        }
    }
}

