/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.awssdk.v1_11.RequestAccess;
import io.opentelemetry.javaagent.tooling.muzzle.NoMuzzle;
import java.util.function.Function;
import javax.annotation.Nullable;

class AwsSdkAttributesExtractor
implements AttributesExtractor<Request<?>, Response<?>> {
    private static final boolean CAN_GET_RESPONSE_METADATA = AwsSdkAttributesExtractor.canGetResponseMetadata();
    private static final AttributeKey<String> AWS_REQUEST_ID = AttributeKey.stringKey((String)"aws.request_id");
    private static final AttributeKey<String> AWS_SECRETSMANAGER_SECRET_ARN = AttributeKey.stringKey((String)"aws.secretsmanager.secret.arn");
    private static final AttributeKey<String> AWS_LAMBDA_RESOURCE_MAPPING_ID = AttributeKey.stringKey((String)"aws.lambda.resource_mapping.id");
    private static final AttributeKey<String> AWS_SNS_TOPIC_ARN = AttributeKey.stringKey((String)"aws.sns.topic.arn");
    private static final AttributeKey<String> AWS_STEP_FUNCTIONS_ACTIVITY_ARN = AttributeKey.stringKey((String)"aws.step_functions.activity.arn");
    private static final AttributeKey<String> AWS_STEP_FUNCTIONS_STATE_MACHINE_ARN = AttributeKey.stringKey((String)"aws.step_functions.state_machine.arn");

    AwsSdkAttributesExtractor() {
    }

    private static boolean canGetResponseMetadata() {
        try {
            Class<?> clazz = Class.forName("com.amazonaws.AmazonWebServiceResult");
            clazz.getMethod("getSdkResponseMetadata", new Class[0]);
            return true;
        }
        catch (ClassNotFoundException | NoSuchMethodException exception) {
            return false;
        }
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, Request<?> request) {
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        AwsSdkAttributesExtractor.setAttribute(attributes, AWS_LAMBDA_RESOURCE_MAPPING_ID, originalRequest, RequestAccess::getLambdaResourceMappingId);
        AwsSdkAttributesExtractor.setAttribute(attributes, AWS_SNS_TOPIC_ARN, originalRequest, RequestAccess::getSnsTopicArn);
        AwsSdkAttributesExtractor.setAttribute(attributes, AWS_STEP_FUNCTIONS_STATE_MACHINE_ARN, originalRequest, RequestAccess::getStateMachineArn);
        AwsSdkAttributesExtractor.setAttribute(attributes, AWS_STEP_FUNCTIONS_ACTIVITY_ARN, originalRequest, RequestAccess::getStepFunctionsActivityArn);
    }

    public void onEnd(AttributesBuilder attributes, Context context, Request<?> request, @Nullable Response<?> response, @Nullable Throwable error) {
        String requestId;
        ResponseMetadata responseMetadata;
        Object awsResp = AwsSdkAttributesExtractor.getAwsResponse(response);
        if (awsResp != null) {
            AwsSdkAttributesExtractor.setAttribute(attributes, AWS_SECRETSMANAGER_SECRET_ARN, awsResp, RequestAccess::getSecretArn);
            AwsSdkAttributesExtractor.setAttribute(attributes, AWS_LAMBDA_RESOURCE_MAPPING_ID, awsResp, RequestAccess::getLambdaResourceMappingId);
            AwsSdkAttributesExtractor.setAttribute(attributes, AWS_SNS_TOPIC_ARN, awsResp, RequestAccess::getSnsTopicArn);
            AwsSdkAttributesExtractor.setAttribute(attributes, AWS_STEP_FUNCTIONS_STATE_MACHINE_ARN, awsResp, RequestAccess::getStateMachineArn);
            AwsSdkAttributesExtractor.setAttribute(attributes, AWS_STEP_FUNCTIONS_ACTIVITY_ARN, awsResp, RequestAccess::getStepFunctionsActivityArn);
        }
        if ((responseMetadata = AwsSdkAttributesExtractor.getResponseMetadata(response)) != null && (requestId = responseMetadata.getRequestId()) != null) {
            attributes.put(AWS_REQUEST_ID, (Object)requestId);
        }
    }

    @NoMuzzle
    private static ResponseMetadata getResponseMetadata(Response<?> response) {
        if (CAN_GET_RESPONSE_METADATA && response != null && response.getAwsResponse() instanceof AmazonWebServiceResult) {
            AmazonWebServiceResult awsResp = (AmazonWebServiceResult)response.getAwsResponse();
            return awsResp.getSdkResponseMetadata();
        }
        return null;
    }

    public static void setAttribute(AttributesBuilder attributes, AttributeKey<String> key, Object carrier, Function<Object, String> getter) {
        String value = getter.apply(carrier);
        if (value != null) {
            attributes.put(key, (Object)value);
        }
    }

    private static Object getAwsResponse(Response<?> response) {
        if (response == null) {
            return null;
        }
        return response.getAwsResponse();
    }
}

