/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsExperimentalAttributes;
import io.opentelemetry.instrumentation.awssdk.v1_11.RequestAccess;
import java.util.function.Function;
import javax.annotation.Nullable;

class AwsSdkExperimentalAttributesExtractor
implements AttributesExtractor<Request<?>, Response<?>> {
    private static final String COMPONENT_NAME = "java-aws-sdk";

    AwsSdkExperimentalAttributesExtractor() {
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, Request<?> request) {
        attributes.put(AwsExperimentalAttributes.AWS_AGENT, (Object)COMPONENT_NAME);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        AwsSdkExperimentalAttributesExtractor.setRequestAttribute(attributes, AwsExperimentalAttributes.AWS_QUEUE_NAME, originalRequest, RequestAccess::getQueueName);
        AwsSdkExperimentalAttributesExtractor.setRequestAttribute(attributes, AwsExperimentalAttributes.AWS_LAMBDA_NAME, originalRequest, RequestAccess::getLambdaName);
    }

    private static void setRequestAttribute(AttributesBuilder attributes, AttributeKey<String> key, Object request, Function<Object, String> getter) {
        String value = getter.apply(request);
        if (value != null) {
            attributes.put(key, (Object)value);
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, Request<?> request, @Nullable Response<?> response, @Nullable Throwable error) {
        Object awsResponse = AwsSdkExperimentalAttributesExtractor.getAwsResponse(response);
        if (awsResponse != null) {
            AwsSdkExperimentalAttributesExtractor.setRequestAttribute(attributes, AwsExperimentalAttributes.AWS_LAMBDA_ARN, awsResponse, RequestAccess::getLambdaArn);
        }
    }

    private static Object getAwsResponse(Response<?> response) {
        if (response == null) {
            return null;
        }
        return response.getAwsResponse();
    }
}

