/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.awssdk.v1_11.RequestAccess;
import javax.annotation.Nullable;

public class SnsAttributesExtractor
implements AttributesExtractor<Request<?>, Response<?>> {
    private static final AttributeKey<String> MESSAGING_DESTINATION_NAME = AttributeKey.stringKey((String)"messaging.destination.name");

    public void onStart(AttributesBuilder attributes, Context parentContext, Request<?> request) {
        String destination = SnsAttributesExtractor.findMessageDestination(request.getOriginalRequest());
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, MESSAGING_DESTINATION_NAME, (Object)destination);
    }

    private static String findMessageDestination(AmazonWebServiceRequest request) {
        String destination = RequestAccess.getTopicArn(request);
        if (destination != null) {
            return destination;
        }
        return RequestAccess.getTargetArn(request);
    }

    public void onEnd(AttributesBuilder attributes, Context context, Request<?> request, @Nullable Response<?> response, @Nullable Throwable error) {
    }
}

