/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.autoconfigure;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetry;
import io.opentelemetry.javaagent.bootstrap.internal.ExperimentalConfig;
import io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig;
import java.util.Collections;
import java.util.List;

public final class AwsSdkSingletons {
    private static final boolean HAS_INSTRUMENTATION_CONFIG = AwsSdkSingletons.hasAgentConfiguration();
    private static final AwsSdkTelemetry TELEMETRY = AwsSdkTelemetry.builder((OpenTelemetry)GlobalOpenTelemetry.get()).setCapturedHeaders(AwsSdkSingletons.getCapturedHeaders()).setCaptureExperimentalSpanAttributes(AwsSdkSingletons.captureExperimentalSpanAttributes()).setMessagingReceiveInstrumentationEnabled(AwsSdkSingletons.messagingReceiveInstrumentationEnabled()).setUseConfiguredPropagatorForMessaging(AwsSdkSingletons.useMessagingPropagator()).setRecordIndividualHttpError(AwsSdkSingletons.recordIndividualHttpError()).build();

    private static boolean hasAgentConfiguration() {
        try {
            Class.forName("io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static List<String> getCapturedHeaders() {
        if (HAS_INSTRUMENTATION_CONFIG) {
            return ExperimentalConfig.get().getMessagingHeaders();
        }
        return ConfigPropertiesUtil.getList((String)"otel.instrumentation.messaging.experimental.capture-headers", Collections.emptyList());
    }

    private static boolean captureExperimentalSpanAttributes() {
        return AwsSdkSingletons.getBoolean("otel.instrumentation.aws-sdk.experimental-span-attributes", false);
    }

    private static boolean messagingReceiveInstrumentationEnabled() {
        if (HAS_INSTRUMENTATION_CONFIG) {
            return ExperimentalConfig.get().messagingReceiveInstrumentationEnabled();
        }
        return ConfigPropertiesUtil.getBoolean((String)"otel.instrumentation.messaging.experimental.receive-telemetry.enabled", (boolean)false);
    }

    private static boolean useMessagingPropagator() {
        return AwsSdkSingletons.getBoolean("otel.instrumentation.aws-sdk.experimental-use-propagator-for-messaging", false);
    }

    private static boolean recordIndividualHttpError() {
        return AwsSdkSingletons.getBoolean("otel.instrumentation.aws-sdk.experimental-record-individual-http-error", false);
    }

    private static boolean getBoolean(String name, boolean defaultValue) {
        if (HAS_INSTRUMENTATION_CONFIG) {
            return InstrumentationConfig.get().getBoolean(name, defaultValue);
        }
        return ConfigPropertiesUtil.getBoolean((String)name, (boolean)defaultValue);
    }

    public static AwsSdkTelemetry telemetry() {
        return TELEMETRY;
    }

    private AwsSdkSingletons() {
    }
}

