/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

final class SqsMessageAccess {
    @Nullable
    private static final MethodHandle GET_ATTRIBUTES;

    static Map<String, String> getAttributes(Object message) {
        if (GET_ATTRIBUTES == null) {
            return Collections.emptyMap();
        }
        try {
            return GET_ATTRIBUTES.invoke(message);
        }
        catch (Throwable t) {
            return Collections.emptyMap();
        }
    }

    private SqsMessageAccess() {
    }

    static {
        Class<?> messageClass = null;
        try {
            messageClass = Class.forName("software.amazon.awssdk.services.sqs.model.Message");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (messageClass != null) {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodHandle getAttributes = null;
            try {
                getAttributes = lookup.findVirtual(messageClass, "attributesAsStrings", MethodType.methodType(Map.class));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
            GET_ATTRIBUTES = getAttributes;
        } else {
            GET_ATTRIBUTES = null;
        }
    }
}

