/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.TracingExecutionInterceptor;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;

class AwsSdkHttpAttributesGetter
implements HttpClientAttributesGetter<ExecutionAttributes, SdkHttpResponse> {
    AwsSdkHttpAttributesGetter() {
    }

    public String getUrl(ExecutionAttributes request) {
        SdkHttpRequest httpRequest = (SdkHttpRequest)request.getAttribute(TracingExecutionInterceptor.SDK_HTTP_REQUEST_ATTRIBUTE);
        return httpRequest.getUri().toString();
    }

    public String getMethod(ExecutionAttributes request) {
        SdkHttpRequest httpRequest = (SdkHttpRequest)request.getAttribute(TracingExecutionInterceptor.SDK_HTTP_REQUEST_ATTRIBUTE);
        return httpRequest.method().name();
    }

    public List<String> getRequestHeader(ExecutionAttributes request, String name) {
        SdkHttpRequest httpRequest = (SdkHttpRequest)request.getAttribute(TracingExecutionInterceptor.SDK_HTTP_REQUEST_ATTRIBUTE);
        List value = (List)httpRequest.headers().get(name);
        return value == null ? Collections.emptyList() : value;
    }

    public Integer getStatusCode(ExecutionAttributes request, SdkHttpResponse response, @Nullable Throwable error) {
        return response.statusCode();
    }

    public List<String> getResponseHeader(ExecutionAttributes request, SdkHttpResponse response, String name) {
        List value = (List)response.headers().get(name);
        return value == null ? Collections.emptyList() : value;
    }
}

