/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.contrib.awsxray.propagator.AwsXrayPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkInstrumenterFactory;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkRequestType;
import io.opentelemetry.instrumentation.awssdk.v2_2.FieldMapper;
import io.opentelemetry.instrumentation.awssdk.v2_2.RequestHeaderSetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsMessageAccess;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsParentContext;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsReceiveMessageRequestAccess;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;

final class TracingExecutionInterceptor
implements ExecutionInterceptor {
    static final ExecutionAttribute<Context> CONTEXT_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".Context");
    static final ExecutionAttribute<Scope> SCOPE_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".Scope");
    static final ExecutionAttribute<AwsSdkRequest> AWS_SDK_REQUEST_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".AwsSdkRequest");
    static final ExecutionAttribute<SdkHttpRequest> SDK_HTTP_REQUEST_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".SdkHttpRequest");
    static final ExecutionAttribute<SdkRequest> SDK_REQUEST_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".SdkRequest");
    private final Instrumenter<ExecutionAttributes, SdkHttpResponse> requestInstrumenter;
    private final Instrumenter<ExecutionAttributes, SdkHttpResponse> consumerInstrumenter;
    private final boolean captureExperimentalSpanAttributes;
    private final FieldMapper fieldMapper;

    TracingExecutionInterceptor(Instrumenter<ExecutionAttributes, SdkHttpResponse> requestInstrumenter, Instrumenter<ExecutionAttributes, SdkHttpResponse> consumerInstrumenter, boolean captureExperimentalSpanAttributes) {
        this.requestInstrumenter = requestInstrumenter;
        this.consumerInstrumenter = consumerInstrumenter;
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        this.fieldMapper = new FieldMapper();
    }

    public void afterMarshalling(Context.AfterMarshalling context, ExecutionAttributes executionAttributes) {
        Context parentOtelContext = Context.current();
        executionAttributes.putAttribute(SDK_REQUEST_ATTRIBUTE, (Object)context.request());
        SdkHttpRequest httpRequest = context.httpRequest();
        executionAttributes.putAttribute(SDK_HTTP_REQUEST_ATTRIBUTE, (Object)httpRequest);
        if (!this.requestInstrumenter.shouldStart(parentOtelContext, (Object)executionAttributes)) {
            return;
        }
        Context otelContext = this.requestInstrumenter.start(parentOtelContext, (Object)executionAttributes);
        executionAttributes.putAttribute(CONTEXT_ATTRIBUTE, (Object)otelContext);
        if (((ClientType)executionAttributes.getAttribute(SdkExecutionAttribute.CLIENT_TYPE)).equals((Object)ClientType.SYNC)) {
            executionAttributes.putAttribute(SCOPE_ATTRIBUTE, (Object)otelContext.makeCurrent());
        }
        Span span = Span.fromContext((Context)otelContext);
        try {
            AwsSdkRequest awsSdkRequest = AwsSdkRequest.ofSdkRequest(context.request());
            if (awsSdkRequest != null) {
                executionAttributes.putAttribute(AWS_SDK_REQUEST_ATTRIBUTE, (Object)awsSdkRequest);
                this.populateRequestAttributes(span, awsSdkRequest, context.request(), executionAttributes);
            }
        }
        catch (Throwable throwable) {
            this.requestInstrumenter.end(otelContext, (Object)executionAttributes, null, throwable);
            TracingExecutionInterceptor.clearAttributes(executionAttributes);
            throw throwable;
        }
    }

    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        List<String> existingAttributeNames;
        SdkRequest request = context.request();
        if (SqsReceiveMessageRequestAccess.isInstance(request) && !(existingAttributeNames = TracingExecutionInterceptor.getAttributeNames(request)).contains("AWSTraceHeader")) {
            ArrayList<String> attributeNames = new ArrayList<String>();
            attributeNames.addAll(existingAttributeNames);
            attributeNames.add("AWSTraceHeader");
            SdkRequest.Builder builder = request.toBuilder();
            SqsReceiveMessageRequestAccess.attributeNamesWithStrings(builder, attributeNames);
            return builder.build();
        }
        return request;
    }

    private static List<String> getAttributeNames(SdkRequest request) {
        Optional optional = request.getValueForField("AttributeNames", List.class);
        return optional.isPresent() ? (List)optional.get() : Collections.emptyList();
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpRequest httpRequest = context.httpRequest();
        Context otelContext = TracingExecutionInterceptor.getContext(executionAttributes);
        if (otelContext == null) {
            return httpRequest;
        }
        SdkHttpRequest.Builder builder = (SdkHttpRequest.Builder)httpRequest.toBuilder();
        AwsXrayPropagator.getInstance().inject(otelContext, (Object)builder, (TextMapSetter)RequestHeaderSetter.INSTANCE);
        return (SdkHttpRequest)builder.build();
    }

    private void populateRequestAttributes(Span span, AwsSdkRequest awsSdkRequest, SdkRequest sdkRequest, ExecutionAttributes attributes) {
        this.fieldMapper.mapToAttributes(sdkRequest, awsSdkRequest, span);
        if (awsSdkRequest.type() == AwsSdkRequestType.DYNAMODB) {
            span.setAttribute(SemanticAttributes.DB_SYSTEM, (Object)"dynamodb");
            String operation = (String)attributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
            if (operation != null) {
                span.setAttribute(SemanticAttributes.DB_OPERATION, (Object)operation);
            }
        }
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        Context otelContext;
        if (SqsReceiveMessageRequestAccess.isInstance(context.request())) {
            this.afterConsumerResponse(executionAttributes, context.response(), context.httpResponse());
        }
        if ((otelContext = TracingExecutionInterceptor.getContext(executionAttributes)) != null) {
            executionAttributes.putAttribute(SDK_HTTP_REQUEST_ATTRIBUTE, (Object)context.httpRequest());
            Span span = Span.fromContext((Context)otelContext);
            TracingExecutionInterceptor.onUserAgentHeaderAvailable(span, executionAttributes);
            this.onSdkResponse(span, context.response(), executionAttributes);
            this.requestInstrumenter.end(otelContext, (Object)executionAttributes, (Object)context.httpResponse(), null);
        }
        TracingExecutionInterceptor.clearAttributes(executionAttributes);
    }

    private void afterConsumerResponse(ExecutionAttributes executionAttributes, SdkResponse response, SdkHttpResponse httpResponse) {
        List<Object> messages = TracingExecutionInterceptor.getMessages(response);
        for (Object message : messages) {
            this.createConsumerSpan(message, executionAttributes, httpResponse);
        }
    }

    private static List<Object> getMessages(SdkResponse response) {
        Optional optional = response.getValueForField("Messages", List.class);
        return optional.isPresent() ? (List)optional.get() : Collections.emptyList();
    }

    private void createConsumerSpan(Object message, ExecutionAttributes executionAttributes, SdkHttpResponse httpResponse) {
        Context parentContext = SqsParentContext.ofSystemAttributes(SqsMessageAccess.getAttributes(message));
        if (this.consumerInstrumenter.shouldStart(parentContext, (Object)executionAttributes)) {
            Context context = this.consumerInstrumenter.start(parentContext, (Object)executionAttributes);
            this.consumerInstrumenter.end(context, (Object)executionAttributes, (Object)httpResponse, null);
        }
    }

    private static void onUserAgentHeaderAvailable(Span span, ExecutionAttributes request) {
        List<String> userAgent = AwsSdkInstrumenterFactory.httpAttributesGetter.getRequestHeader(request, "User-Agent");
        if (!userAgent.isEmpty()) {
            span.setAttribute(SemanticAttributes.USER_AGENT_ORIGINAL, (Object)userAgent.get(0));
        }
    }

    private void onSdkResponse(Span span, SdkResponse response, ExecutionAttributes executionAttributes) {
        if (this.captureExperimentalSpanAttributes) {
            AwsSdkRequest sdkRequest;
            if (response instanceof AwsResponse) {
                span.setAttribute("aws.requestId", ((AwsResponse)response).responseMetadata().requestId());
            }
            if ((sdkRequest = (AwsSdkRequest)((Object)executionAttributes.getAttribute(AWS_SDK_REQUEST_ATTRIBUTE))) != null) {
                this.fieldMapper.mapToAttributes(response, sdkRequest, span);
            }
        }
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        Context otelContext = TracingExecutionInterceptor.getContext(executionAttributes);
        if (otelContext != null) {
            this.requestInstrumenter.end(otelContext, (Object)executionAttributes, null, context.exception());
        }
        TracingExecutionInterceptor.clearAttributes(executionAttributes);
    }

    private static void clearAttributes(ExecutionAttributes executionAttributes) {
        Scope scope = (Scope)executionAttributes.getAttribute(SCOPE_ATTRIBUTE);
        if (scope != null) {
            scope.close();
        }
        executionAttributes.putAttribute(CONTEXT_ATTRIBUTE, null);
        executionAttributes.putAttribute(AWS_SDK_REQUEST_ATTRIBUTE, null);
        executionAttributes.putAttribute(SDK_HTTP_REQUEST_ATTRIBUTE, null);
    }

    static Context getContext(ExecutionAttributes attributes) {
        return (Context)attributes.getAttribute(CONTEXT_ATTRIBUTE);
    }
}

