/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.utils.builder.SdkBuilder;

final class SqsMessageAttributeValueAccess {
    @Nullable
    private static final MethodHandle GET_STRING_VALUE;
    @Nullable
    private static final MethodHandle STRING_VALUE;
    @Nullable
    private static final MethodHandle DATA_TYPE;
    @Nullable
    private static final MethodHandle BUILDER;

    static String getStringValue(SdkPojo messageAttributeValue) {
        if (GET_STRING_VALUE == null) {
            return null;
        }
        try {
            return GET_STRING_VALUE.invoke(messageAttributeValue);
        }
        catch (Throwable t) {
            return null;
        }
    }

    static SdkBuilder stringValue(SdkBuilder builder, String value) {
        if (STRING_VALUE == null) {
            return null;
        }
        try {
            return STRING_VALUE.invoke(builder, value);
        }
        catch (Throwable t) {
            return null;
        }
    }

    static SdkBuilder dataType(SdkBuilder builder, String dataType) {
        if (DATA_TYPE == null) {
            return null;
        }
        try {
            return DATA_TYPE.invoke(builder, dataType);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private SqsMessageAttributeValueAccess() {
    }

    public static SdkBuilder builder() {
        if (BUILDER == null) {
            return null;
        }
        try {
            return BUILDER.invoke();
        }
        catch (Throwable e) {
            return null;
        }
    }

    static {
        Class<?> messageAttributeValueClass = null;
        try {
            messageAttributeValueClass = Class.forName("software.amazon.awssdk.services.sqs.model.MessageAttributeValue");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (messageAttributeValueClass != null) {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodHandle getStringValue = null;
            try {
                getStringValue = lookup.findVirtual(messageAttributeValueClass, "stringValue", MethodType.methodType(String.class));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
            GET_STRING_VALUE = getStringValue;
        } else {
            GET_STRING_VALUE = null;
        }
        Class<?> builderClass = null;
        if (messageAttributeValueClass != null) {
            try {
                builderClass = Class.forName("software.amazon.awssdk.services.sqs.model.MessageAttributeValue$Builder");
            }
            catch (Throwable getStringValue) {
                // empty catch block
            }
        }
        if (builderClass != null) {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodHandle stringValue = null;
            try {
                stringValue = lookup.findVirtual(builderClass, "stringValue", MethodType.methodType(builderClass, String.class));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
            STRING_VALUE = stringValue;
            MethodHandle dataType = null;
            try {
                dataType = lookup.findVirtual(builderClass, "dataType", MethodType.methodType(builderClass, String.class));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
            DATA_TYPE = dataType;
            MethodHandle builder = null;
            try {
                builder = lookup.findStatic(messageAttributeValueClass, "builder", MethodType.methodType(builderClass));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
            BUILDER = builder;
        } else {
            STRING_VALUE = null;
            DATA_TYPE = null;
            BUILDER = null;
        }
    }
}

