/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.SdkRequest;

final class SqsSendMessageRequestAccess {
    @Nullable
    private static final MethodHandle MESSAGE_ATTRIBUTES;

    static boolean isInstance(SdkRequest request) {
        return request.getClass().getName().equals("software.amazon.awssdk.services.sqs.model.SendMessageRequest");
    }

    static void messageAttributes(SdkRequest.Builder builder, Map<String, SdkPojo> messageAttributes) {
        if (MESSAGE_ATTRIBUTES == null) {
            return;
        }
        try {
            MESSAGE_ATTRIBUTES.invoke(builder, messageAttributes);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static Map<String, SdkPojo> messageAttributes(SdkRequest request) {
        Optional optional = request.getValueForField("AttributeNames", Map.class);
        return optional.isPresent() ? (Map)optional.get() : Collections.emptyMap();
    }

    private SqsSendMessageRequestAccess() {
    }

    static {
        Class<?> sendMessageRequestClass = null;
        try {
            sendMessageRequestClass = Class.forName("software.amazon.awssdk.services.sqs.model.SendMessageRequest$Builder");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (sendMessageRequestClass != null) {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodHandle messageAttributes = null;
            try {
                messageAttributes = lookup.findVirtual(sendMessageRequestClass, "messageAttributes", MethodType.methodType(sendMessageRequestClass, Map.class));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
            MESSAGE_ATTRIBUTES = messageAttributes;
        } else {
            MESSAGE_ATTRIBUTES = null;
        }
    }
}

