/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import java.util.logging.Level;
import java.util.logging.Logger;

final class PluginImplUtil {
    private static final Logger logger = Logger.getLogger(PluginImplUtil.class.getName());

    private PluginImplUtil() {
    }

    static boolean isImplPresent(String implSimpleClassName) {
        String implFullClassName = PluginImplUtil.class.getName().replace(".PluginImplUtil", "." + implSimpleClassName);
        try {
            Class.forName(implFullClassName);
            return true;
        }
        catch (ClassNotFoundException | LinkageError e) {
            logger.log(Level.FINE, e, () -> implFullClassName + " not present. Most likely, corresponding SDK component is either not on classpath or incompatible.");
            return false;
        }
    }
}

