/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcClientAttributesExtractor;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkHttpAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkRpcAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkSpanKindExtractor;
import java.util.Arrays;
import java.util.List;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpResponse;

final class AwsSdkInstrumenterFactory {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.aws-sdk-2.2";
    static final AttributesExtractor<ExecutionAttributes, SdkHttpResponse> rpcAttributesExtractor = RpcClientAttributesExtractor.create((RpcAttributesGetter)AwsSdkRpcAttributesGetter.INSTANCE);
    private static final AwsSdkExperimentalAttributesExtractor experimentalAttributesExtractor = new AwsSdkExperimentalAttributesExtractor();
    static final AwsSdkHttpAttributesGetter httpAttributesGetter = new AwsSdkHttpAttributesGetter();
    static final AttributesExtractor<ExecutionAttributes, SdkHttpResponse> httpAttributesExtractor = HttpClientAttributesExtractor.create((HttpClientAttributesGetter)httpAttributesGetter);
    private static final AwsSdkSpanKindExtractor spanKindExtractor = new AwsSdkSpanKindExtractor();
    private static final List<AttributesExtractor<ExecutionAttributes, SdkHttpResponse>> defaultAttributesExtractors = Arrays.asList(rpcAttributesExtractor);
    private static final List<AttributesExtractor<ExecutionAttributes, SdkHttpResponse>> extendedAttributesExtractors = Arrays.asList(rpcAttributesExtractor, experimentalAttributesExtractor);
    private static final List<AttributesExtractor<ExecutionAttributes, SdkHttpResponse>> defaultConsumerAttributesExtractors = Arrays.asList(rpcAttributesExtractor, httpAttributesExtractor);
    private static final List<AttributesExtractor<ExecutionAttributes, SdkHttpResponse>> extendedConsumerAttributesExtractors = Arrays.asList(rpcAttributesExtractor, httpAttributesExtractor, experimentalAttributesExtractor);

    static Instrumenter<ExecutionAttributes, SdkHttpResponse> requestInstrumenter(OpenTelemetry openTelemetry, boolean captureExperimentalSpanAttributes) {
        return AwsSdkInstrumenterFactory.createInstrumenter(openTelemetry, captureExperimentalSpanAttributes ? extendedAttributesExtractors : defaultAttributesExtractors, spanKindExtractor);
    }

    static Instrumenter<ExecutionAttributes, SdkHttpResponse> consumerInstrumenter(OpenTelemetry openTelemetry, boolean captureExperimentalSpanAttributes) {
        return AwsSdkInstrumenterFactory.createInstrumenter(openTelemetry, captureExperimentalSpanAttributes ? extendedConsumerAttributesExtractors : defaultConsumerAttributesExtractors, (SpanKindExtractor<ExecutionAttributes>)SpanKindExtractor.alwaysConsumer());
    }

    private static Instrumenter<ExecutionAttributes, SdkHttpResponse> createInstrumenter(OpenTelemetry openTelemetry, List<AttributesExtractor<ExecutionAttributes, SdkHttpResponse>> extractors, SpanKindExtractor<ExecutionAttributes> spanKindExtractor) {
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, AwsSdkInstrumenterFactory::spanName).addAttributesExtractors(extractors).buildInstrumenter(spanKindExtractor);
    }

    private static String spanName(ExecutionAttributes attributes) {
        String awsServiceName = (String)attributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME);
        String awsOperation = (String)attributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
        return awsServiceName + "." + awsOperation;
    }

    private AwsSdkInstrumenterFactory() {
    }
}

