/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetry;

public final class AwsSdkTelemetryBuilder {
    private final OpenTelemetry openTelemetry;
    private boolean captureExperimentalSpanAttributes;
    private boolean useMessagingPropagator;
    private boolean recordIndividualHttpError;
    private boolean useXrayPropagator = true;

    AwsSdkTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public AwsSdkTelemetryBuilder setCaptureExperimentalSpanAttributes(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        return this;
    }

    @CanIgnoreReturnValue
    public AwsSdkTelemetryBuilder setUseConfiguredPropagatorForMessaging(boolean useMessagingPropagator) {
        this.useMessagingPropagator = useMessagingPropagator;
        return this;
    }

    @CanIgnoreReturnValue
    public AwsSdkTelemetryBuilder setRecordIndividualHttpError(boolean recordIndividualHttpError) {
        this.recordIndividualHttpError = recordIndividualHttpError;
        return this;
    }

    @CanIgnoreReturnValue
    AwsSdkTelemetryBuilder setUseXrayPropagator(boolean useMessagingPropagator) {
        this.useXrayPropagator = useMessagingPropagator;
        return this;
    }

    public AwsSdkTelemetry build() {
        return new AwsSdkTelemetry(this.openTelemetry, this.captureExperimentalSpanAttributes, this.useMessagingPropagator, this.useXrayPropagator, this.recordIndividualHttpError);
    }
}

