/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcClientAttributesExtractor;
import io.opentelemetry.instrumentation.awssdk.v2_2.AbstractSqsRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkHttpAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkHttpClientSuppressionAttributesExtractor;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkRpcAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.Response;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsParentContext;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsProcessRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsProcessRequestAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsReceiveRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsReceiveRequestAttributesGetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;

final class AwsSdkInstrumenterFactory {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.aws-sdk-2.2";
    private static final AttributesExtractor<ExecutionAttributes, Response> rpcAttributesExtractor = RpcClientAttributesExtractor.create((RpcAttributesGetter)AwsSdkRpcAttributesGetter.INSTANCE);
    private static final AwsSdkExperimentalAttributesExtractor experimentalAttributesExtractor = new AwsSdkExperimentalAttributesExtractor();
    static final AwsSdkHttpAttributesGetter httpAttributesGetter = new AwsSdkHttpAttributesGetter();
    static final AttributesExtractor<ExecutionAttributes, Response> httpAttributesExtractor = HttpClientAttributesExtractor.create((HttpClientAttributesGetter)httpAttributesGetter);
    private static final AttributesExtractor<ExecutionAttributes, Response> httpClientSuppressionAttributesExtractor = new AwsSdkHttpClientSuppressionAttributesExtractor();
    private static final List<AttributesExtractor<ExecutionAttributes, Response>> defaultAttributesExtractors = Arrays.asList(rpcAttributesExtractor, httpClientSuppressionAttributesExtractor);
    private static final List<AttributesExtractor<ExecutionAttributes, Response>> extendedAttributesExtractors = Arrays.asList(rpcAttributesExtractor, experimentalAttributesExtractor, httpClientSuppressionAttributesExtractor);
    private static final List<AttributesExtractor<ExecutionAttributes, Response>> defaultConsumerAttributesExtractors = Arrays.asList(rpcAttributesExtractor, httpAttributesExtractor);
    private static final List<AttributesExtractor<ExecutionAttributes, Response>> extendedConsumerAttributesExtractors = Arrays.asList(rpcAttributesExtractor, httpAttributesExtractor, experimentalAttributesExtractor);
    private final OpenTelemetry openTelemetry;
    @Nullable
    private final TextMapPropagator messagingPropagator;
    private final List<String> capturedHeaders;
    private final boolean captureExperimentalSpanAttributes;
    private final boolean messagingReceiveInstrumentationEnabled;
    private final boolean useXrayPropagator;

    AwsSdkInstrumenterFactory(OpenTelemetry openTelemetry, @Nullable TextMapPropagator messagingPropagator, List<String> capturedHeaders, boolean captureExperimentalSpanAttributes, boolean messagingReceiveInstrumentationEnabled, boolean useXrayPropagator) {
        this.openTelemetry = openTelemetry;
        this.messagingPropagator = messagingPropagator;
        this.capturedHeaders = capturedHeaders;
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        this.messagingReceiveInstrumentationEnabled = messagingReceiveInstrumentationEnabled;
        this.useXrayPropagator = useXrayPropagator;
    }

    Instrumenter<ExecutionAttributes, Response> requestInstrumenter() {
        return AwsSdkInstrumenterFactory.createInstrumenter(this.openTelemetry, AwsSdkInstrumenterFactory::spanName, SpanKindExtractor.alwaysClient(), this.attributesExtractors(), Collections.emptyList(), true);
    }

    private List<AttributesExtractor<ExecutionAttributes, Response>> attributesExtractors() {
        return this.captureExperimentalSpanAttributes ? extendedAttributesExtractors : defaultAttributesExtractors;
    }

    private List<AttributesExtractor<ExecutionAttributes, Response>> consumerAttributesExtractors() {
        return this.captureExperimentalSpanAttributes ? extendedConsumerAttributesExtractors : defaultConsumerAttributesExtractors;
    }

    private <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> messagingAttributesExtractor(MessagingAttributesGetter<REQUEST, RESPONSE> getter, MessageOperation operation) {
        return MessagingAttributesExtractor.builder(getter, (MessageOperation)operation).setCapturedHeaders(this.capturedHeaders).build();
    }

    Instrumenter<SqsReceiveRequest, Response> consumerReceiveInstrumenter() {
        MessageOperation operation = MessageOperation.RECEIVE;
        SqsReceiveRequestAttributesGetter getter = SqsReceiveRequestAttributesGetter.INSTANCE;
        AttributesExtractor<SqsReceiveRequest, Response> messagingAttributeExtractor = this.messagingAttributesExtractor(getter, operation);
        return AwsSdkInstrumenterFactory.createInstrumenter(this.openTelemetry, MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation), SpanKindExtractor.alwaysConsumer(), AwsSdkInstrumenterFactory.toSqsRequestExtractors(this.consumerAttributesExtractors(), Function.identity()), Collections.singletonList(messagingAttributeExtractor), this.messagingReceiveInstrumentationEnabled);
    }

    Instrumenter<SqsProcessRequest, Void> consumerProcessInstrumenter() {
        MessageOperation operation = MessageOperation.PROCESS;
        SqsProcessRequestAttributesGetter getter = SqsProcessRequestAttributesGetter.INSTANCE;
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractors(AwsSdkInstrumenterFactory.toSqsRequestExtractors(this.consumerAttributesExtractors(), unused -> null)).addAttributesExtractor(this.messagingAttributesExtractor(getter, operation));
        if (this.messagingReceiveInstrumentationEnabled) {
            builder.addSpanLinksExtractor((spanLinks, parentContext, request) -> {
                Context extracted = SqsParentContext.ofMessage(request.getMessage(), this.messagingPropagator, this.useXrayPropagator);
                spanLinks.addLink(Span.fromContext((Context)extracted).getSpanContext());
            });
        }
        return builder.buildInstrumenter(SpanKindExtractor.alwaysConsumer());
    }

    private static <RESPONSE> List<AttributesExtractor<AbstractSqsRequest, RESPONSE>> toSqsRequestExtractors(List<AttributesExtractor<ExecutionAttributes, Response>> extractors, final Function<RESPONSE, Response> responseConverter) {
        ArrayList<AttributesExtractor<AbstractSqsRequest, RESPONSE>> result = new ArrayList<AttributesExtractor<AbstractSqsRequest, RESPONSE>>();
        for (final AttributesExtractor<ExecutionAttributes, Response> extractor : extractors) {
            result.add(new AttributesExtractor<AbstractSqsRequest, RESPONSE>(){

                public void onStart(AttributesBuilder attributes, Context parentContext, AbstractSqsRequest sqsRequest) {
                    extractor.onStart(attributes, parentContext, (Object)sqsRequest.getRequest());
                }

                public void onEnd(AttributesBuilder attributes, Context context, AbstractSqsRequest sqsRequest, @Nullable RESPONSE response, @Nullable Throwable error) {
                    extractor.onEnd(attributes, context, (Object)sqsRequest.getRequest(), (Object)((Response)responseConverter.apply(response)), error);
                }
            });
        }
        return result;
    }

    Instrumenter<ExecutionAttributes, Response> producerInstrumenter() {
        MessageOperation operation = MessageOperation.PUBLISH;
        SqsAttributesGetter getter = SqsAttributesGetter.INSTANCE;
        AttributesExtractor<ExecutionAttributes, Response> messagingAttributeExtractor = this.messagingAttributesExtractor(getter, operation);
        return AwsSdkInstrumenterFactory.createInstrumenter(this.openTelemetry, MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation), SpanKindExtractor.alwaysProducer(), this.attributesExtractors(), Collections.singletonList(messagingAttributeExtractor), true);
    }

    private static <REQUEST, RESPONSE> Instrumenter<REQUEST, RESPONSE> createInstrumenter(OpenTelemetry openTelemetry, SpanNameExtractor<REQUEST> spanNameExtractor, SpanKindExtractor<REQUEST> spanKindExtractor, List<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributeExtractors, List<AttributesExtractor<REQUEST, RESPONSE>> additionalAttributeExtractors, boolean enabled) {
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, spanNameExtractor).addAttributesExtractors(attributeExtractors).addAttributesExtractors(additionalAttributeExtractors).setEnabled(enabled).buildInstrumenter(spanKindExtractor);
    }

    private static String spanName(ExecutionAttributes attributes) {
        String awsServiceName = (String)attributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME);
        String awsOperation = (String)attributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
        return awsServiceName + "." + awsOperation;
    }
}

