/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.Response;
import io.opentelemetry.instrumentation.awssdk.v2_2.SqsAccess;
import io.opentelemetry.instrumentation.awssdk.v2_2.TracingExecutionInterceptor;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;

enum SqsAttributesGetter implements MessagingAttributesGetter<ExecutionAttributes, Response>
{
    INSTANCE;


    public String getSystem(ExecutionAttributes request) {
        return "AmazonSQS";
    }

    public String getDestination(ExecutionAttributes request) {
        int i;
        SdkRequest sdkRequest = (SdkRequest)request.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE);
        String queueUrl = SqsAccess.getQueueUrl(sdkRequest);
        if (queueUrl != null && (i = queueUrl.lastIndexOf(47)) > 0) {
            return queueUrl.substring(i + 1);
        }
        return null;
    }

    public boolean isTemporaryDestination(ExecutionAttributes request) {
        return false;
    }

    @Nullable
    public String getConversationId(ExecutionAttributes request) {
        return null;
    }

    @Nullable
    public Long getMessagePayloadSize(ExecutionAttributes request) {
        return null;
    }

    @Nullable
    public Long getMessagePayloadCompressedSize(ExecutionAttributes request) {
        return null;
    }

    @Nullable
    public String getMessageId(ExecutionAttributes request, @Nullable Response response) {
        if (response != null && response.getSdkResponse() != null) {
            SdkResponse sdkResponse = response.getSdkResponse();
            return SqsAccess.getMessageId(sdkResponse);
        }
        return null;
    }

    public List<String> getMessageHeader(ExecutionAttributes request, String name) {
        SdkRequest sdkRequest = (SdkRequest)request.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE);
        String value = SqsAccess.getMessageAttribute(sdkRequest, name);
        return value != null ? Collections.singletonList(value) : Collections.emptyList();
    }
}

