/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.extension.aws.AwsXrayPropagator;
import io.opentelemetry.instrumentation.api.tracer.HttpClientTracer;
import io.opentelemetry.instrumentation.api.tracer.net.NetPeerAttributes;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkInjectAdapter;
import java.net.URI;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpHeaders;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;

final class AwsSdkHttpClientTracer
extends HttpClientTracer<SdkHttpRequest, SdkHttpRequest.Builder, SdkHttpResponse> {
    AwsSdkHttpClientTracer(OpenTelemetry openTelemetry) {
        super(openTelemetry, new NetPeerAttributes());
    }

    public Context startSpan(Context parentContext, ExecutionAttributes attributes) {
        String spanName = AwsSdkHttpClientTracer.spanName(attributes);
        Span span = this.spanBuilder(parentContext, spanName, SpanKind.CLIENT).startSpan();
        return this.withClientSpan(parentContext, span);
    }

    public void inject(Context context, SdkHttpRequest.Builder builder) {
        AwsXrayPropagator.getInstance().inject(context, (Object)builder, this.getSetter());
    }

    protected String method(SdkHttpRequest request) {
        return request.method().name();
    }

    protected URI url(SdkHttpRequest request) {
        return request.getUri();
    }

    protected Integer status(SdkHttpResponse response) {
        return response.statusCode();
    }

    protected String requestHeader(SdkHttpRequest sdkHttpRequest, String name) {
        return AwsSdkHttpClientTracer.header((SdkHttpHeaders)sdkHttpRequest, name);
    }

    protected String responseHeader(SdkHttpResponse sdkHttpResponse, String name) {
        return AwsSdkHttpClientTracer.header((SdkHttpHeaders)sdkHttpResponse, name);
    }

    protected TextMapSetter<SdkHttpRequest.Builder> getSetter() {
        return AwsSdkInjectAdapter.INSTANCE;
    }

    private static String header(SdkHttpHeaders headers, String name) {
        return headers.firstMatchingHeader(name).orElse(null);
    }

    protected String getInstrumentationName() {
        return "io.opentelemetry.aws-sdk-2.2";
    }

    protected void onRequest(Span span, SdkHttpRequest sdkHttpRequest) {
        super.onRequest(span, (Object)sdkHttpRequest);
    }

    private static String spanName(ExecutionAttributes attributes) {
        String awsServiceName = (String)attributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME);
        String awsOperation = (String)attributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
        return awsServiceName + "." + awsOperation;
    }
}

