/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.FieldMapping;
import io.opentelemetry.instrumentation.awssdk.v2_2.MethodHandleFactory;
import io.opentelemetry.instrumentation.awssdk.v2_2.Serializer;
import java.util.List;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.utils.StringUtils;

class FieldMapper {
    private final Serializer serializer;
    private final MethodHandleFactory methodHandleFactory;

    FieldMapper() {
        this.serializer = new Serializer();
        this.methodHandleFactory = new MethodHandleFactory();
    }

    FieldMapper(Serializer serializer, MethodHandleFactory methodHandleFactory) {
        this.methodHandleFactory = methodHandleFactory;
        this.serializer = serializer;
    }

    void mapToAttributes(SdkRequest sdkRequest, AwsSdkRequest request, Span span) {
        this.mapToAttributes(field -> sdkRequest.getValueForField(field, Object.class).orElse(null), FieldMapping.Type.REQUEST, request, span);
    }

    void mapToAttributes(SdkResponse sdkResponse, AwsSdkRequest request, Span span) {
        this.mapToAttributes(field -> sdkResponse.getValueForField(field, Object.class).orElse(null), FieldMapping.Type.RESPONSE, request, span);
    }

    private void mapToAttributes(Function<String, Object> fieldValueProvider, FieldMapping.Type type, AwsSdkRequest request, Span span) {
        for (FieldMapping fieldMapping : request.fields(type)) {
            this.mapToAttributes(fieldValueProvider, fieldMapping, span);
        }
        for (FieldMapping fieldMapping : request.type().fields(type)) {
            this.mapToAttributes(fieldValueProvider, fieldMapping, span);
        }
    }

    private void mapToAttributes(Function<String, Object> fieldValueProvider, FieldMapping fieldMapping, Span span) {
        String value;
        List<String> path = fieldMapping.getFields();
        Object target = fieldValueProvider.apply(path.get(0));
        for (int i = 1; i < path.size() && target != null; ++i) {
            target = this.next(target, path.get(i));
        }
        if (target != null && !StringUtils.isEmpty((CharSequence)(value = this.serializer.serialize(target)))) {
            span.setAttribute(fieldMapping.getAttribute(), value);
        }
    }

    private @Nullable Object next(Object current, String fieldName) {
        try {
            return this.methodHandleFactory.forField(current.getClass(), fieldName).invoke(current);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

