/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkHttpClientTracer;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkRequestType;
import io.opentelemetry.instrumentation.awssdk.v2_2.FieldMapper;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;

final class TracingExecutionInterceptor
implements ExecutionInterceptor {
    static final ExecutionAttribute<Context> CONTEXT_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".Context");
    static final ExecutionAttribute<Scope> SCOPE_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".Scope");
    static final ExecutionAttribute<AwsSdkRequest> AWS_SDK_REQUEST_ATTRIBUTE = new ExecutionAttribute(TracingExecutionInterceptor.class.getName() + ".AwsSdkRequest");
    static final String COMPONENT_NAME = "java-aws-sdk";
    private final AwsSdkHttpClientTracer tracer;
    private final boolean captureExperimentalSpanAttributes;
    private final FieldMapper fieldMapper;

    TracingExecutionInterceptor(AwsSdkHttpClientTracer tracer, boolean captureExperimentalSpanAttributes) {
        this.tracer = tracer;
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        this.fieldMapper = new FieldMapper();
    }

    public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
        Context parentOtelContext = Context.current();
        if (!this.tracer.shouldStartSpan(parentOtelContext)) {
            return;
        }
        Context otelContext = this.tracer.startSpan(parentOtelContext, executionAttributes);
        executionAttributes.putAttribute(CONTEXT_ATTRIBUTE, (Object)otelContext);
        if (((ClientType)executionAttributes.getAttribute(SdkExecutionAttribute.CLIENT_TYPE)).equals((Object)ClientType.SYNC)) {
            executionAttributes.putAttribute(SCOPE_ATTRIBUTE, (Object)otelContext.makeCurrent());
        }
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Context otelContext = TracingExecutionInterceptor.getContext(executionAttributes);
        if (otelContext == null) {
            return context.httpRequest();
        }
        SdkHttpRequest.Builder builder = (SdkHttpRequest.Builder)context.httpRequest().toBuilder();
        this.tracer.inject(otelContext, builder);
        return (SdkHttpRequest)builder.build();
    }

    public void afterMarshalling(Context.AfterMarshalling context, ExecutionAttributes executionAttributes) {
        Context otelContext = TracingExecutionInterceptor.getContext(executionAttributes);
        if (otelContext == null) {
            return;
        }
        Span span = Span.fromContext((Context)otelContext);
        this.tracer.onRequest(span, context.httpRequest());
        AwsSdkRequest awsSdkRequest = AwsSdkRequest.ofSdkRequest(context.request());
        if (awsSdkRequest != null) {
            executionAttributes.putAttribute(AWS_SDK_REQUEST_ATTRIBUTE, (Object)awsSdkRequest);
            this.populateRequestAttributes(span, awsSdkRequest, context.request(), executionAttributes);
        }
        this.populateGenericAttributes(span, executionAttributes);
    }

    private void populateRequestAttributes(Span span, AwsSdkRequest awsSdkRequest, SdkRequest sdkRequest, ExecutionAttributes attributes) {
        this.fieldMapper.mapToAttributes(sdkRequest, awsSdkRequest, span);
        if (awsSdkRequest.type() == AwsSdkRequestType.DynamoDB) {
            span.setAttribute(SemanticAttributes.DB_SYSTEM, (Object)"dynamodb");
            String operation = (String)attributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
            if (operation != null) {
                span.setAttribute(SemanticAttributes.DB_OPERATION, (Object)operation);
            }
        }
    }

    private void populateGenericAttributes(Span span, ExecutionAttributes attributes) {
        if (this.captureExperimentalSpanAttributes) {
            String awsServiceName = (String)attributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME);
            String awsOperation = (String)attributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
            span.setAttribute("aws.agent", COMPONENT_NAME);
            span.setAttribute("aws.service", awsServiceName);
            span.setAttribute("aws.operation", awsOperation);
        }
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        Context otelContext = TracingExecutionInterceptor.getContext(executionAttributes);
        TracingExecutionInterceptor.clearAttributes(executionAttributes);
        Span span = Span.fromContext((Context)otelContext);
        this.onUserAgentHeaderAvailable(span, context.httpRequest());
        this.onSdkResponse(span, context.response(), executionAttributes);
        this.tracer.end(otelContext, context.httpResponse());
    }

    private void onUserAgentHeaderAvailable(Span span, SdkHttpRequest request) {
        span.setAttribute(SemanticAttributes.HTTP_USER_AGENT, (Object)this.tracer.requestHeader(request, "User-Agent"));
    }

    private void onSdkResponse(Span span, SdkResponse response, ExecutionAttributes executionAttributes) {
        if (this.captureExperimentalSpanAttributes) {
            AwsSdkRequest sdkRequest;
            if (response instanceof AwsResponse) {
                span.setAttribute("aws.requestId", ((AwsResponse)response).responseMetadata().requestId());
            }
            if ((sdkRequest = (AwsSdkRequest)((Object)executionAttributes.getAttribute(AWS_SDK_REQUEST_ATTRIBUTE))) != null) {
                this.fieldMapper.mapToAttributes(response, sdkRequest, span);
            }
        }
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        Context otelContext = TracingExecutionInterceptor.getContext(executionAttributes);
        TracingExecutionInterceptor.clearAttributes(executionAttributes);
        this.tracer.endExceptionally(otelContext, context.exception());
    }

    private static void clearAttributes(ExecutionAttributes executionAttributes) {
        Scope scope = (Scope)executionAttributes.getAttribute(SCOPE_ATTRIBUTE);
        if (scope != null) {
            scope.close();
        }
        executionAttributes.putAttribute(CONTEXT_ATTRIBUTE, null);
        executionAttributes.putAttribute(AWS_SDK_REQUEST_ATTRIBUTE, null);
    }

    private static Context getContext(ExecutionAttributes attributes) {
        return (Context)attributes.getAttribute(CONTEXT_ATTRIBUTE);
    }
}

