/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiAttributesGetter;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.BedrockRuntimeAccess;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.Response;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.TracingExecutionInterceptor;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;

enum BedrockRuntimeAttributesGetter implements GenAiAttributesGetter<ExecutionAttributes, Response>
{
    INSTANCE;


    public String getOperationName(ExecutionAttributes executionAttributes) {
        String operation = (String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME);
        if (operation != null) {
            switch (operation) {
                case "Converse": 
                case "ConverseStream": {
                    return "chat";
                }
            }
            return null;
        }
        return null;
    }

    public String getSystem(ExecutionAttributes executionAttributes) {
        return "aws.bedrock";
    }

    @Nullable
    public String getRequestModel(ExecutionAttributes executionAttributes) {
        return BedrockRuntimeAccess.getModelId((SdkRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE));
    }

    @Nullable
    public Long getRequestSeed(ExecutionAttributes executionAttributes) {
        return null;
    }

    @Nullable
    public List<String> getRequestEncodingFormats(ExecutionAttributes executionAttributes) {
        return null;
    }

    @Nullable
    public Double getRequestFrequencyPenalty(ExecutionAttributes executionAttributes) {
        return null;
    }

    @Nullable
    public Long getRequestMaxTokens(ExecutionAttributes executionAttributes) {
        return BedrockRuntimeAccess.getMaxTokens((SdkRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE));
    }

    @Nullable
    public Double getRequestPresencePenalty(ExecutionAttributes executionAttributes) {
        return null;
    }

    @Nullable
    public List<String> getRequestStopSequences(ExecutionAttributes executionAttributes) {
        return BedrockRuntimeAccess.getStopSequences((SdkRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE));
    }

    @Nullable
    public Double getRequestTemperature(ExecutionAttributes executionAttributes) {
        return BedrockRuntimeAccess.getTemperature((SdkRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE));
    }

    @Nullable
    public Double getRequestTopK(ExecutionAttributes executionAttributes) {
        return null;
    }

    @Nullable
    public Double getRequestTopP(ExecutionAttributes executionAttributes) {
        return BedrockRuntimeAccess.getTopP((SdkRequest)executionAttributes.getAttribute(TracingExecutionInterceptor.SDK_REQUEST_ATTRIBUTE));
    }

    public List<String> getResponseFinishReasons(ExecutionAttributes executionAttributes, @Nullable Response response) {
        if (response == null) {
            return Collections.emptyList();
        }
        List<String> stopReasons = BedrockRuntimeAccess.getStopReasons(response);
        if (stopReasons == null) {
            return Collections.emptyList();
        }
        return stopReasons;
    }

    @Nullable
    public String getResponseId(ExecutionAttributes executionAttributes, Response response) {
        return null;
    }

    @Nullable
    public String getResponseModel(ExecutionAttributes executionAttributes, Response response) {
        return null;
    }

    @Nullable
    public Long getUsageInputTokens(ExecutionAttributes executionAttributes, @Nullable Response response) {
        if (response == null) {
            return null;
        }
        return BedrockRuntimeAccess.getUsageInputTokens(response);
    }

    @Nullable
    public Long getUsageOutputTokens(ExecutionAttributes executionAttributes, @Nullable Response response) {
        if (response == null) {
            return null;
        }
        return BedrockRuntimeAccess.getUsageOutputTokens(response);
    }

    private static final class GenAiOperationNameIncubatingValues {
        static final String CHAT = "chat";

        private GenAiOperationNameIncubatingValues() {
        }
    }

    static final class GenAiSystemIncubatingValues {
        static final String AWS_BEDROCK = "aws.bedrock";

        private GenAiSystemIncubatingValues() {
        }
    }
}

