/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetry;
import java.util.List;

public abstract class AbstractAwsSdkTelemetryFactory {
    protected abstract List<String> getCapturedHeaders();

    private boolean captureExperimentalSpanAttributes() {
        return this.getBoolean("otel.instrumentation.aws-sdk.experimental-span-attributes", false);
    }

    protected abstract boolean messagingReceiveInstrumentationEnabled();

    private boolean useMessagingPropagator() {
        return this.getBoolean("otel.instrumentation.aws-sdk.experimental-use-propagator-for-messaging", false);
    }

    private boolean recordIndividualHttpError() {
        return this.getBoolean("otel.instrumentation.aws-sdk.experimental-record-individual-http-error", false);
    }

    private boolean genaiCaptureMessageContent() {
        return this.getBoolean("otel.instrumentation.genai.capture-message-content", false);
    }

    protected abstract boolean getBoolean(String var1, boolean var2);

    public AwsSdkTelemetry telemetry() {
        return AwsSdkTelemetry.builder(GlobalOpenTelemetry.get()).setCapturedHeaders(this.getCapturedHeaders()).setCaptureExperimentalSpanAttributes(this.captureExperimentalSpanAttributes()).setMessagingReceiveInstrumentationEnabled(this.messagingReceiveInstrumentationEnabled()).setUseConfiguredPropagatorForMessaging(this.useMessagingPropagator()).setRecordIndividualHttpError(this.recordIndividualHttpError()).setGenaiCaptureMessageContent(this.genaiCaptureMessageContent()).build();
    }
}

