/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.logs.Logger;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetryBuilder;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.AwsSdkInstrumenterFactory;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.BedrockRuntimeImpl;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.Response;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsImpl;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsProcessRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsReceiveRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.TracingExecutionInterceptor;
import io.opentelemetry.javaagent.tooling.muzzle.NoMuzzle;
import java.util.List;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsClient;

public class AwsSdkTelemetry {
    private final Instrumenter<ExecutionAttributes, Response> requestInstrumenter;
    private final Instrumenter<SqsReceiveRequest, Response> consumerReceiveInstrumenter;
    private final Instrumenter<SqsProcessRequest, Response> consumerProcessInstrumenter;
    private final Instrumenter<ExecutionAttributes, Response> producerInstrumenter;
    private final Instrumenter<ExecutionAttributes, Response> dynamoDbInstrumenter;
    private final Instrumenter<ExecutionAttributes, Response> bedrockRuntimeInstrumenter;
    private final Logger eventLogger;
    private final boolean captureExperimentalSpanAttributes;
    @Nullable
    private final TextMapPropagator messagingPropagator;
    private final boolean useXrayPropagator;
    private final boolean recordIndividualHttpError;
    private final boolean genAiCaptureMessageContent;

    public static AwsSdkTelemetry create(OpenTelemetry openTelemetry) {
        return AwsSdkTelemetry.builder(openTelemetry).build();
    }

    public static AwsSdkTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new AwsSdkTelemetryBuilder(openTelemetry);
    }

    AwsSdkTelemetry(OpenTelemetry openTelemetry, List<String> capturedHeaders, boolean captureExperimentalSpanAttributes, boolean useMessagingPropagator, boolean useXrayPropagator, boolean recordIndividualHttpError, boolean messagingReceiveInstrumentationEnabled, boolean genAiCaptureMessageContent) {
        this.useXrayPropagator = useXrayPropagator;
        this.messagingPropagator = useMessagingPropagator ? openTelemetry.getPropagators().getTextMapPropagator() : null;
        AwsSdkInstrumenterFactory instrumenterFactory = new AwsSdkInstrumenterFactory(openTelemetry, this.messagingPropagator, capturedHeaders, captureExperimentalSpanAttributes, messagingReceiveInstrumentationEnabled, useXrayPropagator);
        this.requestInstrumenter = instrumenterFactory.requestInstrumenter();
        this.consumerReceiveInstrumenter = instrumenterFactory.consumerReceiveInstrumenter();
        this.consumerProcessInstrumenter = instrumenterFactory.consumerProcessInstrumenter();
        this.producerInstrumenter = instrumenterFactory.producerInstrumenter();
        this.dynamoDbInstrumenter = instrumenterFactory.dynamoDbInstrumenter();
        this.bedrockRuntimeInstrumenter = instrumenterFactory.bedrockRuntimeInstrumenter();
        this.eventLogger = instrumenterFactory.eventLogger();
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        this.recordIndividualHttpError = recordIndividualHttpError;
        this.genAiCaptureMessageContent = genAiCaptureMessageContent;
    }

    public ExecutionInterceptor newExecutionInterceptor() {
        return new TracingExecutionInterceptor(this.requestInstrumenter, this.consumerReceiveInstrumenter, this.consumerProcessInstrumenter, this.producerInstrumenter, this.dynamoDbInstrumenter, this.bedrockRuntimeInstrumenter, this.eventLogger, this.captureExperimentalSpanAttributes, this.messagingPropagator, this.useXrayPropagator, this.recordIndividualHttpError, this.genAiCaptureMessageContent);
    }

    @NoMuzzle
    public SqsClient wrap(SqsClient sqsClient) {
        return SqsImpl.wrap(sqsClient);
    }

    @NoMuzzle
    public SqsAsyncClient wrap(SqsAsyncClient sqsClient) {
        return SqsImpl.wrap(sqsClient);
    }

    @NoMuzzle
    public BedrockRuntimeAsyncClient wrapBedrockRuntimeClient(BedrockRuntimeAsyncClient bedrockClient) {
        return BedrockRuntimeImpl.wrap(bedrockClient, this.eventLogger, this.genAiCaptureMessageContent);
    }
}

