/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.instrumentation.awssdk.v2_2.internal.AwsSdkRequestType;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.FieldMapping;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkRequest;

enum AwsSdkRequest {
    DynamoDbRequest(AwsSdkRequestType.DYNAMODB, "DynamoDbRequest", new FieldMapping[0]),
    S3Request(AwsSdkRequestType.S3, "S3Request", new FieldMapping[0]),
    SnsRequest(AwsSdkRequestType.SNS, "SnsRequest", new FieldMapping[0]),
    SqsRequest(AwsSdkRequestType.SQS, "SqsRequest", new FieldMapping[0]),
    KinesisRequest(AwsSdkRequestType.KINESIS, "KinesisRequest", new FieldMapping[0]),
    SecretsManagerRequest(AwsSdkRequestType.SECRETSMANAGER, "SecretsManagerRequest", new FieldMapping[0]),
    StepFunctionsRequest(AwsSdkRequestType.STEPFUNCTIONS, "SfnRequest", new FieldMapping[0]),
    BatchGetItem(AwsSdkRequestType.DYNAMODB, "dynamodb.model.BatchGetItemRequest", FieldMapping.request("aws.dynamodb.table_names", "RequestItems"), FieldMapping.response("aws.dynamodb.consumed_capacity", "ConsumedCapacity")),
    BatchWriteItem(AwsSdkRequestType.DYNAMODB, "dynamodb.model.BatchWriteItemRequest", FieldMapping.request("aws.dynamodb.table_names", "RequestItems"), FieldMapping.response("aws.dynamodb.consumed_capacity", "ConsumedCapacity"), FieldMapping.response("aws.dynamodb.item_collection_metrics", "ItemCollectionMetrics")),
    CreateTable(AwsSdkRequestType.DYNAMODB, "dynamodb.model.CreateTableRequest", FieldMapping.request("aws.dynamodb.global_secondary_indexes", "GlobalSecondaryIndexes"), FieldMapping.request("aws.dynamodb.local_secondary_indexes", "LocalSecondaryIndexes"), FieldMapping.request("aws.dynamodb.provisioned_throughput.read_capacity_units", "ProvisionedThroughput.ReadCapacityUnits"), FieldMapping.request("aws.dynamodb.provisioned_throughput.write_capacity_units", "ProvisionedThroughput.WriteCapacityUnits")),
    DeleteItem(AwsSdkRequestType.DYNAMODB, "dynamodb.model.DeleteItemRequest", FieldMapping.response("aws.dynamodb.consumed_capacity", "ConsumedCapacity"), FieldMapping.response("aws.dynamodb.item_collection_metrics", "ItemCollectionMetrics")),
    GetItem(AwsSdkRequestType.DYNAMODB, "dynamodb.model.GetItemRequest", FieldMapping.request("aws.dynamodb.projection_expression", "ProjectionExpression"), FieldMapping.response("aws.dynamodb.consumed_capacity", "ConsumedCapacity"), FieldMapping.request("aws.dynamodb.consistent_read", "ConsistentRead")),
    ListTables(AwsSdkRequestType.DYNAMODB, "dynamodb.model.ListTablesRequest", FieldMapping.request("aws.dynamodb.exclusive_start_table_name", "ExclusiveStartTableName"), FieldMapping.response("aws.dynamodb.table_count", "TableNames"), FieldMapping.request("aws.dynamodb.limit", "Limit")),
    PutItem(AwsSdkRequestType.DYNAMODB, "dynamodb.model.PutItemRequest", FieldMapping.response("aws.dynamodb.consumed_capacity", "ConsumedCapacity"), FieldMapping.response("aws.dynamodb.item_collection_metrics", "ItemCollectionMetrics")),
    Query(AwsSdkRequestType.DYNAMODB, "dynamodb.model.QueryRequest", FieldMapping.request("aws.dynamodb.attributes_to_get", "AttributesToGet"), FieldMapping.request("aws.dynamodb.consistent_read", "ConsistentRead"), FieldMapping.request("aws.dynamodb.index_name", "IndexName"), FieldMapping.request("aws.dynamodb.limit", "Limit"), FieldMapping.request("aws.dynamodb.projection_expression", "ProjectionExpression"), FieldMapping.request("aws.dynamodb.scan_index_forward", "ScanIndexForward"), FieldMapping.request("aws.dynamodb.select", "Select"), FieldMapping.response("aws.dynamodb.consumed_capacity", "ConsumedCapacity")),
    Scan(AwsSdkRequestType.DYNAMODB, "dynamodb.model.ScanRequest", FieldMapping.request("aws.dynamodb.attributes_to_get", "AttributesToGet"), FieldMapping.request("aws.dynamodb.consistent_read", "ConsistentRead"), FieldMapping.request("aws.dynamodb.index_name", "IndexName"), FieldMapping.request("aws.dynamodb.limit", "Limit"), FieldMapping.request("aws.dynamodb.projection_expression", "ProjectionExpression"), FieldMapping.request("aws.dynamodb.segment", "Segment"), FieldMapping.request("aws.dynamodb.select", "Select"), FieldMapping.request("aws.dynamodb.total_segments", "TotalSegments"), FieldMapping.response("aws.dynamodb.consumed_capacity", "ConsumedCapacity"), FieldMapping.response("aws.dynamodb.count", "Count"), FieldMapping.response("aws.dynamodb.scanned_count", "ScannedCount")),
    UpdateItem(AwsSdkRequestType.DYNAMODB, "dynamodb.model.UpdateItemRequest", FieldMapping.response("aws.dynamodb.consumed_capacity", "ConsumedCapacity"), FieldMapping.response("aws.dynamodb.item_collection_metrics", "ItemCollectionMetrics")),
    UpdateTable(AwsSdkRequestType.DYNAMODB, "dynamodb.model.UpdateTableRequest", FieldMapping.request("aws.dynamodb.attribute_definitions", "AttributeDefinitions"), FieldMapping.request("aws.dynamodb.global_secondary_index_updates", "GlobalSecondaryIndexUpdates"), FieldMapping.request("aws.dynamodb.provisioned_throughput.read_capacity_units", "ProvisionedThroughput.ReadCapacityUnits"), FieldMapping.request("aws.dynamodb.provisioned_throughput.write_capacity_units", "ProvisionedThroughput.WriteCapacityUnits")),
    ConverseRequest(AwsSdkRequestType.BEDROCK_RUNTIME, "bedrockruntime.model.ConverseRequest", FieldMapping.request("gen_ai.request.model", "modelId"));

    private final AwsSdkRequestType type;
    private final String requestClass;
    private final Map<FieldMapping.Type, List<FieldMapping>> fields;

    private AwsSdkRequest(AwsSdkRequestType type, String requestClass, FieldMapping ... fields) {
        this.type = type;
        this.requestClass = requestClass;
        this.fields = Collections.unmodifiableMap(FieldMapping.groupByType(fields));
    }

    @Nullable
    static AwsSdkRequest ofSdkRequest(SdkRequest request) {
        AwsSdkRequest result = AwsSdkRequest.ofType(request.getClass().getName());
        if (result == null) {
            result = AwsSdkRequest.ofType(request.getClass().getSuperclass().getName());
        }
        return result;
    }

    private static AwsSdkRequest ofType(String typeName) {
        for (AwsSdkRequest type : AwsSdkRequest.values()) {
            if (!typeName.endsWith(type.requestClass)) continue;
            return type;
        }
        return null;
    }

    List<FieldMapping> fields(FieldMapping.Type type) {
        return this.fields.get((Object)type);
    }

    AwsSdkRequestType type() {
        return this.type;
    }
}

