/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.AwsExperimentalAttributes;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.FieldMapping;
import java.util.Collections;
import java.util.List;
import java.util.Map;

enum AwsSdkRequestType {
    S3(FieldMapping.request("aws.bucket.name", "Bucket")),
    SQS(FieldMapping.request("aws.queue.url", "QueueUrl"), FieldMapping.request("aws.queue.name", "QueueName")),
    KINESIS(FieldMapping.request("aws.stream.name", "StreamName")),
    DYNAMODB(FieldMapping.request("aws.table.name", "TableName")),
    BEDROCK_RUNTIME(new FieldMapping[0]),
    LAMBDA(FieldMapping.request(AwsExperimentalAttributes.AWS_LAMBDA_NAME.getKey(), "FunctionName"), FieldMapping.request(AttributeKeys.access$000().getKey(), "UUID"), FieldMapping.response(AwsExperimentalAttributes.AWS_LAMBDA_ARN.getKey(), "Configuration.FunctionArn"), FieldMapping.response(AttributeKeys.access$000().getKey(), "UUID")),
    SECRETSMANAGER(FieldMapping.response(AttributeKeys.AWS_SECRETSMANAGER_SECRET_ARN.getKey(), "ARN")),
    SNS(FieldMapping.request(AttributeKeys.MESSAGING_DESTINATION_NAME.getKey(), "TargetArn"), FieldMapping.request(AttributeKeys.MESSAGING_DESTINATION_NAME.getKey(), "TopicArn"), FieldMapping.request(AttributeKeys.AWS_SNS_TOPIC_ARN.getKey(), "TopicArn"), FieldMapping.response(AttributeKeys.AWS_SNS_TOPIC_ARN.getKey(), "TopicArn")),
    STEPFUNCTIONS(FieldMapping.request(AttributeKeys.AWS_STEP_FUNCTIONS_STATE_MACHINE_ARN.getKey(), "stateMachineArn"), FieldMapping.request(AttributeKeys.AWS_STEP_FUNCTIONS_ACTIVITY_ARN.getKey(), "activityArn"));

    private final Map<FieldMapping.Type, List<FieldMapping>> fields;

    private AwsSdkRequestType(FieldMapping ... fieldMappings) {
        this.fields = Collections.unmodifiableMap(FieldMapping.groupByType(fieldMappings));
    }

    List<FieldMapping> fields(FieldMapping.Type type) {
        return this.fields.get((Object)type);
    }

    private static class AttributeKeys {
        private static final AttributeKey<String> AWS_LAMBDA_RESOURCE_MAPPING_ID = AttributeKey.stringKey((String)"aws.lambda.resource_mapping.id");
        static final AttributeKey<String> AWS_SECRETSMANAGER_SECRET_ARN = AttributeKey.stringKey((String)"aws.secretsmanager.secret.arn");
        static final AttributeKey<String> AWS_SNS_TOPIC_ARN = AttributeKey.stringKey((String)"aws.sns.topic.arn");
        static final AttributeKey<String> AWS_STEP_FUNCTIONS_ACTIVITY_ARN = AttributeKey.stringKey((String)"aws.step_functions.activity.arn");
        static final AttributeKey<String> AWS_STEP_FUNCTIONS_STATE_MACHINE_ARN = AttributeKey.stringKey((String)"aws.step_functions.state_machine.arn");
        static final AttributeKey<String> MESSAGING_DESTINATION_NAME = AttributeKey.stringKey((String)"messaging.destination.name");

        private AttributeKeys() {
        }

        static /* synthetic */ AttributeKey access$000() {
            return AWS_LAMBDA_RESOURCE_MAPPING_ID;
        }
    }
}

