/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.Response;
import io.opentelemetry.semconv.DbAttributes;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;

class DynamoDbAttributesExtractor
implements AttributesExtractor<ExecutionAttributes, Response> {
    private static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey((String)"db.operation");
    private static final AttributeKey<String> DB_SYSTEM = AttributeKey.stringKey((String)"db.system");
    private static final String DYNAMODB = "dynamodb";
    private static final String AWS_DYNAMODB = "aws.dynamodb";

    DynamoDbAttributesExtractor() {
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, ExecutionAttributes executionAttributes) {
        String operation;
        if (SemconvStability.emitStableDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DbAttributes.DB_SYSTEM_NAME, (Object)AWS_DYNAMODB);
        }
        if (SemconvStability.emitOldDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_SYSTEM, (Object)DYNAMODB);
        }
        if ((operation = (String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME)) != null) {
            if (SemconvStability.emitStableDatabaseSemconv()) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DbAttributes.DB_OPERATION_NAME, (Object)operation);
            }
            if (SemconvStability.emitOldDatabaseSemconv()) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_OPERATION, (Object)operation);
            }
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, ExecutionAttributes executionAttributes, @Nullable Response response, @Nullable Throwable error) {
    }
}

